

-- Get cumulative net activations of extensions from the time since launch
WITH
activate_deactivate_timestamp AS (
SELECT 'activate' AS table, '2017-09-06 16:00:00'::timestamp AS range_start, MAX(ea.time)::timestamp AS range_end
FROM logs.extension_activate AS ea
WHERE ea.time>=DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '1 days' + INTERVAL '0 hours' - INTERVAL '0 seconds' --yesterday's start date at 00:00:00
UNION ALL
SELECT 'deactivate' AS table, '2017-09-06 16:00:00'::timestamp AS range_start, MAX(ed.time)::timestamp AS range_end
FROM logs.extension_deactivate AS ed
WHERE ed.time>=DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '1 days' + INTERVAL '0 hours' - INTERVAL '0 seconds' --yesterday's start date at 00:00:00
)
, the_timeframe AS (
SELECT DATE_TRUNC('hour', range_start) AS range_start, DATE_TRUNC('hour', range_end) AS range_end
FROM
(SELECT MIN(range_start) AS range_start, MIN(range_end) AS range_end FROM activate_deactivate_timestamp)
)

, extension_activate_log AS (
SELECT DATE_TRUNC('hour',ea.time) AS the_hour, COUNT(1) AS instances_activate--, COUNT(DISTINCT extension_id) AS unique_extensions_activate, COUNT(DISTINCT channel_id) AS unique_channels_activate
FROM logs.extension_activate AS ea
WHERE ea.time>=(SELECT range_start FROM the_timeframe) and ea.time<(SELECT range_end FROM the_timeframe)
GROUP BY 1
)

, extension_deactivate_log AS (
SELECT DATE_TRUNC('hour',ed.time) AS the_hour, COUNT(1) AS instances_deactivate--, COUNT(DISTINCT extension_id) AS unique_extensions_deactivate, COUNT(DISTINCT channel_id) AS unique_channels_deactivate
FROM logs.extension_deactivate AS ed
WHERE ed.time>=(SELECT range_start FROM the_timeframe) and ed.time<(SELECT range_end FROM the_timeframe)
GROUP BY 1
)


SELECT *, SUM(net_activations_per_hour) OVER (ORDER BY the_hour ASC ROWS UNBOUNDED PRECEDING) AS net_activations_cumulative
FROM (
SELECT eal.*, edl.instances_deactivate, eal.instances_activate - edl.instances_deactivate AS net_activations_per_hour
FROM extension_activate_log AS eal
LEFT JOIN extension_deactivate_log AS edl ON eal.the_hour = edl.the_hour
ORDER BY eal.the_hour ASC
)
ORDER BY the_hour ASC
