-- Assumptions:
-- Only broadcasters from PC (no console, no mobile)
-- Look at % of broadcasters using a third party (non-game link) app over the last two years?
-- Apply small bump for our launch and then follow a slightly accelerated growth trajectory similar to 3p API app growth over time

-- Get broadcasters from PC (monthly trend)


WITH
the_timeframe AS (
SELECT '2015-01-01' AS range_start, '2017-09-01' AS range_end
)
, broadcast_software_list AS (
SELECT 'unknown_rtmp' AS broadcast_software --unknown, highest counts here
--UNION ALL SELECT 'octodad' AS broadcast_software --PS4
--UNION ALL SELECT 'candybox' AS broadcast_software --xbox
UNION ALL SELECT 'watch_party' AS broadcast_software --vodcasts
--UNION ALL SELECT 'fme' AS broadcast_software --flash media encoder (no one uses this anymore, so i would assume any values still coming through today are probably software that is erroneously sending a fme value)
--UNION ALL SELECT 'sdk' AS broadcast_software --straight from game broadcast sdk, or mobile/pipboy?
UNION ALL SELECT 'delay' AS broadcast_software --our delay server (partners can set a delay for their stream via their dashboard)
--UNION ALL SELECT 'foster' AS broadcast_software --???
--UNION ALL SELECT 'shieldtablet' AS broadcast_software --nvidia shield tablet built-in broadcasting
)


SELECT DATE_TRUNC('month', mb.time) AS the_month, COUNT(DISTINCT channel_id) AS num_streamers
FROM logs.minute_broadcast AS mb
WHERE mb.broadcaster_software IN (SELECT broadcast_software FROM broadcast_software_list)
AND mb.time>=(SELECT range_start FROM the_timeframe) and mb.time<(SELECT range_end FROM the_timeframe)
GROUP BY 1
ORDER BY 1
