-- Assumptions:
-- Only broadcasters from PC (no console, no mobile)
-- Look at % of broadcasters using a third party (non-game link) app over the last two years?
-- Apply small bump for our launch and then follow a slightly accelerated growth trajectory similar to 3p API app growth over time




-- Get "active apps" sorted by oauth users DESC
WITH
the_timeframe AS (
SELECT '2016-01-01' AS range_start, '2017-09-01' AS range_end
)

, app_active AS (
SELECT client_id, COUNT(DISTINCT user_id) AS num_users_request_oauth
FROM logs.oauth_authorize
WHERE
"time" >= (SELECT range_start FROM the_timeframe) AND "time"< (SELECT range_end FROM the_timeframe)
GROUP BY 1
)

SELECT a.client_id, s.oauth2_client_owner_id AS user_id, REPLACE(s.name, ',', '') AS app_name, a.num_users_request_oauth
FROM app_active AS a
LEFT JOIN analysis.sitedb_oauth2_clients AS s ON a.client_id = s.client_id
WHERE s.is_first_party IS FALSE
AND s.oauth2_client_owner_id IS NOT NULL
ORDER BY a.num_users_request_oauth DESC, s.name ASC
