-- Assumptions:
-- Only broadcasters from PC (no console, no mobile)
-- Look at % of broadcasters using a third party (non-game link) app over the last two years?
-- Apply small bump for our launch and then follow a slightly accelerated growth trajectory similar to 3p API app growth over time

--  range_start | range_end  | num_pc_streamers |     num_apps     | num_streamers_oauth | pct_streamers_oauth
-- -------------+------------+------------------+------------------+---------------------+---------------------
--  2016-08-01  | 2017-09-01 |          4741151 | 3.57148853274478 |             4243451 |   0.89502549064562
--  2016-09-01  | 2017-09-01 |          4492988 | 3.48431545236367 |             3991093 |   0.88829371456144
--  2016-10-01  | 2017-09-01 |          4275767 | 3.39352439140758 |             3769011 |   0.88148184875368
--  2016-11-01  | 2017-09-01 |          4044673 | 3.23495001944533 |             3515410 |   0.86914566393871
--  2016-12-01  | 2017-09-01 |          3812119 | 3.12558579624613 |             3276159 |   0.85940627771588
--  2017-01-01  | 2017-09-01 |          3550931 | 2.98795358175081 |             3004587 |   0.84614063185119
--  2017-02-01  | 2017-09-01 |          3231549 | 2.83948843108986 |             2680300 |   0.82941648107455
--  2017-03-01  | 2017-09-01 |          2932642 | 2.71312147885763 |             2393119 |   0.81602834577149
--  2017-04-01  | 2017-09-01 |          2630013 | 2.49578081933435 |             2091505 |   0.79524511856025
--  2017-05-01  | 2017-09-01 |          2298408 | 2.24121522375488 |             1753561 |   0.76294591734800
--  2017-06-01  | 2017-09-01 |          2065680 | 1.93380000774563 |             1486499 |   0.71961726888966
--  2017-07-01  | 2017-09-01 |          1675824 | 1.4710524494219  |             1033340 |   0.61661606469414
--  2017-08-01  | 2017-09-01 |          1115505 | 1.00221065795312 |              530539 |   0.47560432270586


--  2017-05-01  | 2017-08-01 |          1853119 | 1.87469504117113 |             1311565 |   0.707760807589799
--  2017-06-01  | 2017-08-01 |          1584580 | 1.51982291837585 |             1022122 |   0.645042850471418
--  2017-07-01  | 2017-08-01 |          1107456 | 0.95377513869625 |              529617 |   0.478228480409154


--  2017-04-01  | 2017-07-01 |          1753019 | 1.82207152346894 |             1210341 |   0.690432334161809
--  2017-05-01  | 2017-07-01 |          1324526 | 1.48727393799744 |              824737 |   0.622665768735382
--  2017-06-01  | 2017-07-01 |           987602 | 1.04638204458881 |              511788 |   0.518212802323203


-- Get % streamers that oauth at least 1 non excluded app since Aug 2016
WITH
the_timeframe AS (
SELECT '2017-04-01' AS range_start, '2017-07-01' AS range_end
)
, broadcast_software_list AS (
SELECT 'unknown_rtmp' AS broadcast_software --unknown, highest counts here
--UNION ALL SELECT 'octodad' AS broadcast_software --PS4
--UNION ALL SELECT 'candybox' AS broadcast_software --xbox
UNION ALL SELECT 'watch_party' AS broadcast_software --vodcasts
--UNION ALL SELECT 'fme' AS broadcast_software --flash media encoder (no one uses this anymore, so i would assume any values still coming through today are probably software that is erroneously sending a fme value)
--UNION ALL SELECT 'sdk' AS broadcast_software --straight from game broadcast sdk, or mobile/pipboy?
UNION ALL SELECT 'delay' AS broadcast_software --our delay server (partners can set a delay for their stream via their dashboard)
--UNION ALL SELECT 'foster' AS broadcast_software --???
--UNION ALL SELECT 'shieldtablet' AS broadcast_software --nvidia shield tablet built-in broadcasting
)
, streamer_broadcast_list AS (
SELECT channel_id
FROM logs.minute_broadcast AS mb
WHERE mb.broadcaster_software IN (SELECT broadcast_software FROM broadcast_software_list)
AND mb.time>=(SELECT range_start FROM the_timeframe) and mb.time<(SELECT range_end FROM the_timeframe)
GROUP BY 1
)
, app_exclude_list AS (
SELECT 'mlpjzuoqffzsj3obfbtwhlxeuepuvh' AS client_id
UNION ALL SELECT 'q6batx0epp608isickayubi39itsckt' AS client_id
UNION ALL SELECT 't11hnc4bu1xj2yljd1t4dbruut4srkf' AS client_id
UNION ALL SELECT 'fnkzwj509yyr3u76ltk57nzhkhdd8g' AS client_id
UNION ALL SELECT 'cxcbwgocuez8axmeqe0cmz29ivvxjt2' AS client_id
UNION ALL SELECT 'mfieqnayt3vog4ucp023xjmdcoh35nu' AS client_id
UNION ALL SELECT 'pdw11y2y3bdtadcyknd791u6mqrqry' AS client_id
UNION ALL SELECT 'ik4kgnclcg9gv59ft7voz7ho5zzyuo2' AS client_id
UNION ALL SELECT 'tmc0eeve0f275a2s00faieyqk7gy9qm' AS client_id
UNION ALL SELECT 'saactj7j6kcf5ogqcv4n6zsgx32sy41' AS client_id
UNION ALL SELECT '8tep5yq9jbkflsxweftaxzdopm1og2m' AS client_id
UNION ALL SELECT '8uxbhupm2ehjrxqohmnho5cxisx2rxo' AS client_id
UNION ALL SELECT 'rg5jwqeyulmyy5s5zsu7juu2l3q1ue' AS client_id
UNION ALL SELECT 'nmt37qblda36pvonovdkbopzfzw3wlq' AS client_id
UNION ALL SELECT 't8w2jadpw06vir58z12fg54rfuf66yw' AS client_id
UNION ALL SELECT 'dw1segz99n0yo3y4lngcph092b232v1' AS client_id
UNION ALL SELECT 'v2cr7jjy56uvdjnmd9nbeabp64wzz9' AS client_id
UNION ALL SELECT 'cuqr5b3xhjrcchs1i6i2divwr41z4gb' AS client_id
UNION ALL SELECT 'bs3mowbbusifs5b0rm43e9adg2k3nq' AS client_id
UNION ALL SELECT '52bi3askk5pcwenzrymhsu1hkh0fbyi' AS client_id
UNION ALL SELECT 'pmal66tgjyba508wiriwl6cam1pzd9j' AS client_id
)

, user_oauth_log AS (
SELECT client_id, user_id, 1 AS flag_oauth
FROM logs.oauth_authorize
WHERE
"time" >= (SELECT range_start FROM the_timeframe) AND "time"< (SELECT range_end FROM the_timeframe)
AND client_id NOT IN (SELECT client_id FROM app_exclude_list)
GROUP BY 1,2
)


SELECT tt.*, base.*, base.num_streamers_oauth/base.num_pc_streamers AS pct_streamers_oauth
FROM
(
SELECT COUNT(DISTINCT channel_id)::float AS num_pc_streamers, AVG(num_apps) AS num_apps, SUM(flag_oauth)::float AS num_streamers_oauth
FROM
(
SELECT channel_id, COUNT(DISTINCT client_id)::float AS num_apps, MAX(flag_oauth) AS flag_oauth
FROM
(
SELECT sbl.channel_id, uol.client_id, uol.flag_oauth
FROM streamer_broadcast_list AS sbl
LEFT JOIN user_oauth_log AS uol ON sbl.channel_id = uol.user_id
)
GROUP BY 1
)
) AS base
LEFT JOIN the_timeframe AS tt ON 1=1
