-- Assumptions:
-- Only broadcasters from PC (no console, no mobile)
-- Look at % of broadcasters using a third party (non-game link) app over the last two years?
-- Apply small bump for our launch and then follow a slightly accelerated growth trajectory similar to 3p API app growth over time



-- Get cumulative net activations of extensions from the time since launch
--      range_start     |      range_end      | instances_activate | unique_extensions_activate | unique_channels_activate | instances_deactivate | unique_extensions_deactivate | unique_channels_deactivate | net_activations
-- ---------------------+---------------------+--------------------+----------------------------+--------------------------+----------------------+------------------------------+----------------------------+-----------------
--  2017-09-06 16:00:00 | 2017-09-08 07:00:00 |              55003 |                        151 |                    22826 |                21449 |                           76 |                       9058 |           33554
--  2017-09-06 16:00:00 | 2017-09-08 06:00:00 |              53929 |                        148 |                    22378 |                20973 |                           74 |                       8887 |           32956
--  2017-09-06 16:00:00 | 2017-09-08 05:00:00 |              52894 |                        144 |                    21913 |                20572 |                           73 |                       8727 |           32322
--  2017-09-06 16:00:00 | 2017-09-08 04:00:00 |              52011 |                        144 |                    21546 |                20201 |                           71 |                       8588 |           31810
--  2017-09-06 16:00:00 | 2017-09-08 03:00:00 |              51326 |                        143 |                    21241 |                19937 |                           70 |                       8476 |           31389
--  2017-09-06 16:00:00 | 2017-09-08 02:00:00 |              50481 |                        139 |                    20890 |                19567 |                           69 |                       8333 |           30914
--  2017-09-06 16:00:00 | 2017-09-08 01:00:00 |              49668 |                        136 |                    20553 |                19237 |                           69 |                       8195 |           30431
--  2017-09-06 16:00:00 | 2017-09-08 00:00:00 |              48817 |                        136 |                    20190 |                18901 |                           69 |                       8049 |           29916
--  2017-09-06 16:00:00 | 2017-09-07 23:00:00 |              47847 |                        136 |                    19794 |                18521 |                           69 |                       7897 |           29326
--  2017-09-06 16:00:00 | 2017-09-07 22:00:00 |              46916 |                        134 |                    19375 |                18162 |                           69 |                       7738 |           28754
--  2017-09-06 16:00:00 | 2017-09-07 21:00:00 |              45918 |                        132 |                    18959 |                17778 |                           68 |                       7582 |           28140
--  2017-09-06 16:00:00 | 2017-09-07 20:00:00 |              44670 |                        130 |                    18447 |                17313 |                           65 |                       7400 |           27357
--  2017-09-06 16:00:00 | 2017-09-07 19:00:00 |              43383 |                        127 |                    17873 |                16811 |                           63 |                       7186 |           26572
--  2017-09-06 16:00:00 | 2017-09-07 18:00:00 |              41922 |                        126 |                    17218 |                16234 |                           63 |                       6948 |           25688
--  2017-09-06 16:00:00 | 2017-09-07 17:00:00 |              40005 |                        124 |                    16352 |                15500 |                           62 |                       6651 |           24505
--  2017-09-06 16:00:00 | 2017-09-07 16:00:00 |              38352 |                        120 |                    15642 |                14788 |                           61 |                       6346 |           23564
--  2017-09-06 16:00:00 | 2017-09-07 15:00:00 |              36660 |                        113 |                    14901 |                14149 |                           60 |                       6071 |           22511
--  2017-09-06 16:00:00 | 2017-09-07 14:00:00 |              35103 |                        107 |                    14258 |                13580 |                           57 |                       5806 |           21523
--  2017-09-06 16:00:00 | 2017-09-07 13:00:00 |              33605 |                         98 |                    13671 |                12934 |                           52 |                       5537 |           20671
--  2017-09-06 16:00:00 | 2017-09-07 12:00:00 |              31799 |                         91 |                    12935 |                12223 |                           48 |                       5261 |           19576
--  2017-09-06 16:00:00 | 2017-09-07 11:00:00 |              30088 |                         86 |                    12201 |                11531 |                           48 |                       4983 |           18557
--  2017-09-06 16:00:00 | 2017-09-07 10:00:00 |              28162 |                         84 |                    11416 |                10758 |                           47 |                       4681 |           17404
--  2017-09-06 16:00:00 | 2017-09-07 09:00:00 |              26313 |                         75 |                    10658 |                10031 |                           46 |                       4382 |           16282
--  2017-09-06 16:00:00 | 2017-09-07 08:00:00 |              24727 |                         71 |                    10004 |                 9374 |                           43 |                       4113 |           15353
--  2017-09-06 16:00:00 | 2017-09-07 07:00:00 |              23281 |                         69 |                     9382 |                 8813 |                           41 |                       3866 |           14468
--  2017-09-06 16:00:00 | 2017-09-07 06:00:00 |              21766 |                         66 |                     8798 |                 8185 |                           41 |                       3615 |           13581
--  2017-09-06 16:00:00 | 2017-09-07 05:00:00 |              20344 |                         66 |                     8216 |                 7612 |                           39 |                       3375 |           12732
--  2017-09-06 16:00:00 | 2017-09-07 04:00:00 |              19100 |                         63 |                     7705 |                 7115 |                           38 |                       3161 |           11985
--  2017-09-06 16:00:00 | 2017-09-07 03:00:00 |              18106 |                         60 |                     7268 |                 6754 |                           37 |                       2990 |           11352
--  2017-09-06 16:00:00 | 2017-09-07 02:00:00 |              16987 |                         58 |                     6833 |                 6315 |                           35 |                       2804 |           10672
--  2017-09-06 16:00:00 | 2017-09-07 01:00:00 |              15998 |                         58 |                     6449 |                 5919 |                           34 |                       2628 |           10079
--  2017-09-06 16:00:00 | 2017-09-07 00:00:00 |              14901 |                         55 |                     6012 |                 5507 |                           34 |                       2454 |            9394
--  2017-09-06 16:00:00 | 2017-09-06 23:00:00 |              13691 |                         52 |                     5578 |                 5004 |                           34 |                       2255 |            8687
--  2017-09-06 16:00:00 | 2017-09-06 22:00:00 |              12452 |                         47 |                     5105 |                 4539 |                           30 |                       2052 |            7913
--  2017-09-06 16:00:00 | 2017-09-06 21:00:00 |              11089 |                         45 |                     4548 |                 4048 |                           28 |                       1850 |            7041
--  2017-09-06 16:00:00 | 2017-09-06 20:00:00 |               9556 |                         41 |                     3924 |                 3474 |                           27 |                       1606 |            6082
--  2017-09-06 16:00:00 | 2017-09-06 19:00:00 |               7849 |                         38 |                     3293 |                 2757 |                           27 |                       1322 |            5092
--  2017-09-06 16:00:00 | 2017-09-06 18:00:00 |               5482 |                         30 |                     2365 |                 1855 |                           24 |                        940 |            3627
--  2017-09-06 16:00:00 | 2017-09-06 17:00:00 |               2669 |                         26 |                     1234 |                  813 |                           22 |                        462 |            1856

WITH
the_timeframe AS (
SELECT '2017-09-06 16:00:00'::timestamp AS range_start, '2017-09-08 07:00:00'::timestamp AS range_end
)

, extension_activate_log AS (
SELECT COUNT(1) AS instances_activate, COUNT(DISTINCT extension_id) AS unique_extensions_activate, COUNT(DISTINCT channel_id) AS unique_channels_activate
FROM logs.extension_activate AS ea
WHERE ea.time>=(SELECT range_start FROM the_timeframe) and ea.time<(SELECT range_end FROM the_timeframe)
)

, extension_deactivate_log AS (
SELECT COUNT(1) AS instances_deactivate, COUNT(DISTINCT extension_id) AS unique_extensions_deactivate, COUNT(DISTINCT channel_id) AS unique_channels_deactivate
FROM logs.extension_deactivate AS ed
WHERE ed.time>=(SELECT range_start FROM the_timeframe) and ed.time<(SELECT range_end FROM the_timeframe)
)



SELECT tt.*, eal.*, edl.*, eal.instances_activate - edl.instances_deactivate AS net_activations
FROM extension_activate_log AS eal
LEFT JOIN extension_deactivate_log AS edl ON 1=1
LEFT JOIN the_timeframe AS tt ON 1=1
