-- Hi Ayuha,
--
-- While we are not able to look at the list of users that are participating in the specific chat session you linked in your initial request, we are able to provide some data for you on the /furukawamirin channel.
--
-- Please see this mode report for more details: https://modeanalytics.com/twitch/reports/da3bee0fa05f
--
-- Here is a summary of the data in the mode report:
-- - /furukawamirin has streamed since 2017-05-03, and has streamed mostly Dark Souls III and PLAYERUNKNOWN'S BATTLEGROUNDS
-- - /furukawamirin has created 2347 new viewers, where I define a new viewer as someone who watched the /furukawamirin channel as their first stream, so it is very likely that these users created a twitch account just to chat in the /furukawamirin channel.
--
--
-- Please let us know if this information is enough to answer your business question.

WITH
channel_broadcast_log AS (
SELECT 'jax_live_channel' as the_table, rails_channel_id AS channel_id, LOWER(rails_channel) AS channel_name_lower, usher_id AS stream_id, rails_game_id AS game_id, rails_meta_game AS game
, MIN(time) AS stream_start_time, MAX(time) AS stream_end_time, CAST(EXTRACT(SECONDS FROM (MAX(time) - MIN(time))) AS REAL)/60 AS stream_mins
FROM logs.jax_live_channel
WHERE rails_channel_id =155210284 --furukawamirin
--AND (time)>='2017-06-01 00:00:00' AND (time)<'2017-06-05 00:00:00' --optional time filter
GROUP BY 1,2,3,4,5,6
)


, new_created_accounts AS (
SELECT user_id, login, display_name, created_on, inserted_on
FROM analysis.sitedb_users
WHERE
created_on>= (SELECT MIN(stream_start_time) - INTERVAL '15 minutes' FROM channel_broadcast_log) --start time of rocket league world championship with 15 min buffer
AND created_on<= (SELECT MAX(stream_end_time) + INTERVAL '15 minutes' FROM channel_broadcast_log) --end time of rocket league world championship with 15 min buffer
)

, the_first_video_play AS (

SELECT DISTINCT user_id
, FIRST_VALUE(the_time IGNORE NULLS) OVER (PARTITION BY user_id ORDER BY the_time ROWS BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) AS the_time
, FIRST_VALUE(channel_id IGNORE NULLS) OVER (PARTITION BY user_id ORDER BY the_time ROWS BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) AS channel_id
, FIRST_VALUE(channel IGNORE NULLS) OVER (PARTITION BY user_id ORDER BY the_time ROWS BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) AS channel
, FIRST_VALUE(game IGNORE NULLS) OVER (PARTITION BY user_id ORDER BY the_time ROWS BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) AS game
FROM
(
SELECT CAST(time AS timestamp) AS the_time, channel, channel_id, game, device_id, user_id
FROM logs."video-play"
WHERE player<>'frontpage' --don't count frontpage views for the first "channel" you watch
AND user_id IS NOT NULL AND user_id <> 0
AND user_id IN (SELECT user_id FROM new_created_accounts)
AND time>= (SELECT MIN(stream_start_time) - INTERVAL '15 minutes' FROM channel_broadcast_log) --start time of rocket league world championship with 15 min buffer
AND channel_id IN (155210284) --furukawamirin
ORDER BY user_id, the_time
) AS final

)

SELECT COUNT(DISTINCT a.user_id), COUNT(1) as rows
FROM the_first_video_play a
INNER JOIN new_created_accounts b ON a.user_id=b.user_id
--WHERE a.channel_id = 57781936
