-- by yanghung
-- generate log of data for revlo data
DROP TABLE IF EXISTS    analysis.panalysis933_revlo_log;
CREATE TABLE    analysis.panalysis933_revlo_log    AS


WITH
revlo_user_id AS (
  SELECT *, NVL(user_id_sitedb, NVL(user_id_lr1,user_id_lr2) ) AS user_id
  FROM (
    SELECT base.*, su.user_id AS user_id_sitedb, lr1.user_id AS user_id_lr1, lr2.user_id AS user_id_lr2
    FROM analysis.panalysis_933_revlo_start_dates AS base
    LEFT JOIN analysis.sitedb_users su ON LOWER(base.login)=LOWER(su.login)
    LEFT JOIN logs.login_rename lr1 ON LOWER(base.login)=LOWER(lr1.old_login)
    LEFT JOIN logs.login_rename lr2 ON LOWER(base.login)=LOWER(lr2.new_login)
  ) AS final
)

SELECT user_id, login, MIN(start_date) AS start_date, MAX(end_date) AS end_date
FROM revlo_user_id
GROUP BY 1,2
;
