-- [from mike engle]
-- Do you have information for # of applications for DS by month since launch of the API?
--
-- applications = # requests for API keys from analysis.sitedb_oauth2_clients
-- active applications = >=5 users requesting oauth to that app from logs.oauth_authorize


WITH
the_timeframe AS (
  SELECT '2015-04-01 00:00:00' AS start_time
)

, app_requests AS (
SELECT DATE(DATE_TRUNC('month', created_at)) AS the_month, COUNT(DISTINCT client_id) AS num_app_key_requests
FROM analysis.sitedb_oauth2_clients
WHERE is_first_party IS FALSE
AND created_at >= (SELECT start_time FROM the_timeframe)
GROUP BY 1
)

, app_active AS (
SELECT the_month, COUNT(DISTINCT client_id) AS num_active_apps
FROM
(
SELECT DATE(DATE_TRUNC('month', "time")) AS the_month, client_id, COUNT(DISTINCT user_id) AS num_users_request_oauth
FROM logs.oauth_authorize
WHERE
"time" >= (SELECT start_time FROM the_timeframe)
GROUP BY 1,2
)
WHERE num_users_request_oauth>=5
GROUP BY 1
)

SELECT app_requests.the_month, app_requests.num_app_key_requests, app_active.num_active_apps
FROM app_requests LEFT JOIN app_active ON app_requests.the_month=app_active.the_month
ORDER BY app_requests.the_month
