# messagelogger #

This directory contains an example KCL consumer. It can be run by the
KCL daemon, provided the daemon is installed, using the accompanying
messagelogger.properties configuration file.

To run, just pass the properties filename in as an argument to the
MultiLangDaemon class, making sure it's accessible in the classpath.

You'll need to tweak messagelogger.properties to fit your particular
deployment because it needs an absolute path the the executable which
it will run.

# Setting up the KCL client #

Here's what I did:
```
mkdir /opt/amazon
cd /opt/amazon
git clone https://github.com/awslabs/amazon-kinesis-client.git
cd amazon-kinesis-client

sudo apt-get install maven

mvn clean dependency:copy-dependencies install -Dgpg.skip=true
```

This installs the kinesis client to
`/opt/amazon/amazon-kinesis-client/target/amazon-kinesis-client-1.6.1.jar`,
and puts jars of the dependencies in
`/opt/amazon/amazon-kinesis-client/target/dependency`. Launching the
daemon requires putting those in the classpath, and then invoking
`com.amazonaws.services.kinesis.multilang.MultiLangDaemon` as your
main class. For example:

```
 java -cp "/opt/amazon/amazon-kinesis-client/target/amazon-kinesis-client-1.6.1.jar:/opt/amazon/amazon-kinesis-client/target/dependency/*:." com.amazonaws.services.kinesis.multilang.MultiLangDaemon messagelogger.properties
```
