# WARNING: DO NOT EDIT, AUTO-GENERATED CODE!
# See https://github.com/jkakar/aws-codegen for more details.

defmodule AWS.Batch do
  @moduledoc """
  AWS Batch enables you to run batch computing workloads on the AWS Cloud.
  Batch computing is a common way for developers, scientists, and engineers
  to access large amounts of compute resources, and AWS Batch removes the
  undifferentiated heavy lifting of configuring and managing the required
  infrastructure. AWS Batch will be familiar to users of traditional batch
  computing software. This service can efficiently provision resources in
  response to jobs submitted in order to eliminate capacity constraints,
  reduce compute costs, and deliver results quickly.

  As a fully managed service, AWS Batch enables developers, scientists, and
  engineers to run batch computing workloads of any scale. AWS Batch
  automatically provisions compute resources and optimizes the workload
  distribution based on the quantity and scale of the workloads. With AWS
  Batch, there is no need to install or manage batch computing software,
  which allows you to focus on analyzing results and solving problems. AWS
  Batch reduces operational complexities, saves time, and reduces costs,
  which makes it easy for developers, scientists, and engineers to run their
  batch jobs in the AWS Cloud.
  """

  @doc """
  Cancels a job in an AWS Batch job queue. Jobs that are in the `SUBMITTED`,
  `PENDING`, or `RUNNABLE` state are cancelled. Jobs that have progressed to
  `STARTING` or `RUNNING` are not cancelled (but the API operation still
  succeeds, even if no job is cancelled); these jobs must be terminated with
  the `TerminateJob` operation.
  """
  def cancel_job(client, input, options \\ []) do
    url = "/v1/canceljob"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Creates an AWS Batch compute environment. You can create `MANAGED` or
  `UNMANAGED` compute environments.

  In a managed compute environment, AWS Batch manages the compute resources
  within the environment, based on the compute resources that you specify.
  Instances launched into a managed compute environment use a recent,
  approved version of the Amazon ECS-optimized AMI. You can choose to use
  Amazon EC2 On-Demand Instances in your managed compute environment, or you
  can use Amazon EC2 Spot Instances that only launch when the Spot bid price
  is below a specified percentage of the On-Demand price.

  In an unmanaged compute environment, you can manage your own compute
  resources. This provides more compute resource configuration options, such
  as using a custom AMI, but you must ensure that your AMI meets the Amazon
  ECS container instance AMI specification. For more information, see
  [Container Instance
  AMIs](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html)
  in the *Amazon Elastic Container Service Developer Guide*. After you have
  created your unmanaged compute environment, you can use the
  `DescribeComputeEnvironments` operation to find the Amazon ECS cluster that
  is associated with it and then manually launch your container instances
  into that Amazon ECS cluster. For more information, see [Launching an
  Amazon ECS Container
  Instance](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html)
  in the *Amazon Elastic Container Service Developer Guide*.
  """
  def create_compute_environment(client, input, options \\ []) do
    url = "/v1/createcomputeenvironment"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Creates an AWS Batch job queue. When you create a job queue, you associate
  one or more compute environments to the queue and assign an order of
  preference for the compute environments.

  You also set a priority to the job queue that determines the order in which
  the AWS Batch scheduler places jobs onto its associated compute
  environments. For example, if a compute environment is associated with more
  than one job queue, the job queue with a higher priority is given
  preference for scheduling jobs to that compute environment.
  """
  def create_job_queue(client, input, options \\ []) do
    url = "/v1/createjobqueue"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Deletes an AWS Batch compute environment.

  Before you can delete a compute environment, you must set its state to
  `DISABLED` with the `UpdateComputeEnvironment` API operation and
  disassociate it from any job queues with the `UpdateJobQueue` API
  operation.
  """
  def delete_compute_environment(client, input, options \\ []) do
    url = "/v1/deletecomputeenvironment"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Deletes the specified job queue. You must first disable submissions for a
  queue with the `UpdateJobQueue` operation. All jobs in the queue are
  terminated when you delete a job queue.

  It is not necessary to disassociate compute environments from a queue
  before submitting a `DeleteJobQueue` request.
  """
  def delete_job_queue(client, input, options \\ []) do
    url = "/v1/deletejobqueue"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Deregisters an AWS Batch job definition.
  """
  def deregister_job_definition(client, input, options \\ []) do
    url = "/v1/deregisterjobdefinition"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Describes one or more of your compute environments.

  If you are using an unmanaged compute environment, you can use the
  `DescribeComputeEnvironment` operation to determine the `ecsClusterArn`
  that you should launch your Amazon ECS container instances into.
  """
  def describe_compute_environments(client, input, options \\ []) do
    url = "/v1/describecomputeenvironments"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Describes a list of job definitions. You can specify a `status` (such as
  `ACTIVE`) to only return job definitions that match that status.
  """
  def describe_job_definitions(client, input, options \\ []) do
    url = "/v1/describejobdefinitions"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Describes one or more of your job queues.
  """
  def describe_job_queues(client, input, options \\ []) do
    url = "/v1/describejobqueues"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Describes a list of AWS Batch jobs.
  """
  def describe_jobs(client, input, options \\ []) do
    url = "/v1/describejobs"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Returns a list of task jobs for a specified job queue. You can filter the
  results by job status with the `jobStatus` parameter. If you do not specify
  a status, only `RUNNING` jobs are returned.
  """
  def list_jobs(client, input, options \\ []) do
    url = "/v1/listjobs"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Registers an AWS Batch job definition.
  """
  def register_job_definition(client, input, options \\ []) do
    url = "/v1/registerjobdefinition"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Submits an AWS Batch job from a job definition. Parameters specified during
  `SubmitJob` override parameters defined in the job definition.
  """
  def submit_job(client, input, options \\ []) do
    url = "/v1/submitjob"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Terminates a job in a job queue. Jobs that are in the `STARTING` or
  `RUNNING` state are terminated, which causes them to transition to
  `FAILED`. Jobs that have not progressed to the `STARTING` state are
  cancelled.
  """
  def terminate_job(client, input, options \\ []) do
    url = "/v1/terminatejob"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Updates an AWS Batch compute environment.
  """
  def update_compute_environment(client, input, options \\ []) do
    url = "/v1/updatecomputeenvironment"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  @doc """
  Updates a job queue.
  """
  def update_job_queue(client, input, options \\ []) do
    url = "/v1/updatejobqueue"
    headers = []
    request(client, :post, url, headers, input, options, nil)
  end

  defp request(client, method, url, headers, input, options, success_status_code) do
    client = %{client | service: "batch"}
    host = get_host("batch", client)
    url = get_url(host, url, client)
    headers = Enum.concat([{"Host", host},
                           {"Content-Type", "application/x-amz-json-1.1"}],
                          headers)
    headers = case client.security_token do
      nil -> headers
      _ -> headers ++ [{"X-Amz-Security-Token", client.security_token}]
    end
    payload = encode_payload(input)
    headers = AWS.Request.sign_v4(client, method, url, headers, payload)
    perform_request(method, url, payload, headers, options, success_status_code)
  end

  defp perform_request(method, url, payload, headers, options, nil) do
    case HTTPoison.request(method, url, payload, headers, options) do
      {:ok, response=%HTTPoison.Response{status_code: 200, body: ""}} ->
        {:ok, response}
      {:ok, response=%HTTPoison.Response{status_code: 200, body: body}} ->
        {:ok, Poison.Parser.parse!(body), response}
      {:ok, response=%HTTPoison.Response{status_code: 202, body: body}} ->
        {:ok, Poison.Parser.parse!(body), response}
      {:ok, response=%HTTPoison.Response{status_code: 204, body: body}} ->
        {:ok, Poison.Parser.parse!(body), response}
      {:ok, _response=%HTTPoison.Response{body: body}} ->
        reason = Poison.Parser.parse!(body)["message"]
        {:error, reason}
      {:error, %HTTPoison.Error{reason: reason}} ->
        {:error, %HTTPoison.Error{reason: reason}}
    end
  end

  defp perform_request(method, url, payload, headers, options, success_status_code) do
    case HTTPoison.request(method, url, payload, headers, options) do
      {:ok, response=%HTTPoison.Response{status_code: ^success_status_code, body: ""}} ->
        {:ok, nil, response}
      {:ok, response=%HTTPoison.Response{status_code: ^success_status_code, body: body}} ->
        {:ok, Poison.Parser.parse!(body), response}
      {:ok, _response=%HTTPoison.Response{body: body}} ->
        reason = Poison.Parser.parse!(body)["message"]
        {:error, reason}
      {:error, %HTTPoison.Error{reason: reason}} ->
        {:error, %HTTPoison.Error{reason: reason}}
    end
  end

  defp get_host(endpoint_prefix, client) do
    if client.region == "local" do
      "localhost"
    else
      "#{endpoint_prefix}.#{client.region}.#{client.endpoint}"
    end
  end

  defp get_url(host, url, %{:proto => proto, :port => port}) do
    "#{proto}://#{host}:#{port}#{url}/"
  end

  defp encode_payload(input) do
    if input != nil do
      Poison.Encoder.encode(input, [])
    else
      ""
    end
  end
end
