# Purpose

Since the AASA file is JSON it cannot have comments. This file serves to
document decisions made in the AASA file and explain routes that have been
whitelisted/blacklisted.

# Patterns

Paths that end in `/*` will match URLs that don't have that path component at all. By that I mean `/foo/*` will match the path `/foo`. To account for this, when we want to ensure the trailing component exists, we use `/?*` instead, as this requires the path component to have at least one character.

Routes are evaluated in the specified order, and evaluation stops as soon as any route matches (positive or negative). The route list in the file is kept in sorted order, with exceptions as necessary to ensure correct evaluation.

All routes where we want to blacklist the root `/foo` are listed as `/foo/*` instead, so we don't have to worry about any future `/foo/bar` paths.

# Routes

## `/passport/*`, `/passport-callback/*`

These routes are used by passport after a user logs in to call back to the app.
/passport/callback is used by `web-client` and /passport-callback is used by
`twilight`.

## `/events/*`

The iOS app does not support events yet, but mobile web does so the user shouldn't get that experience.

## `/bits/*`

[CPEPIE-76](https://jira.twitch.com/browse/CPEPIE-76)

## `/bits-checkout/*`

These links come from `bits.twitch.tv` and `twitch.amazon.com/bits` and are part of the bits purchasing process. Deep links need to be disabled for bits mobile checkout. [Slack discussion](https://twitch.slack.com/archives/C03TAQFSF/p1510970036000113)

## `/email-unsubscribe/*`

[IOS-5030](https://jira.twitch.com/browse/IOS-5030)
