job {
    name 'mobile-web-aasa-build'
    using 'TEMPLATE-autobuild'
    logRotator {
        daysToKeep(14)
    }
    publishers {
      archiveArtifacts('.manta/json-validation-outcome')
    }
    scm {
        git {
            remote {
                github 'mobile-web/aasa', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        shell 'rm -rf .manta/'
        shell 'manta -v -proxy'
        saveDeployArtifact 'mobile-web/aasa', '.manta'
    }
    throttleConcurrentBuilds {
      maxPerNode 2
    }
    wrappers {
      colorizeOutput(colorMap = 'xterm')
      environmentVariables {
        env('ENVIRONMENT', 'development')
      }
    }

}

job {
    name "TEMPLATE-mobile-web-aasa-deploy"
    using "TEMPLATE-deploy-aws"

    logRotator {
        daysToKeep(14)
    }

    steps {
        downloadDeployArtifact 'mobile-web/aasa'
        shell """
            set +x
            export AWS_ACCESS_KEY_ID=\$MWC_AWS_ACCESS_KEY
            export AWS_SECRET_ACCESS_KEY=\$MWC_AWS_SECRET_KEY
            set -x
            ./scripts/upload -s "\$BUCKET" -d "\$DISTRIBUTION"
        """
    }
}

// Clean-deploy will fire this job
job {
    name 'mobile-web-aasa-deploy-staging'
    using 'TEMPLATE-mobile-web-aasa-deploy'

    parameters {
        stringParam('BUCKET', 'twitch-mobile-dev-static', 'bucket to hold static assets')
        stringParam('DISTRIBUTION', 'E2WT3FTA1MKXSB', 'the CloudFront distribution to run invalidations on')
    }

    wrappers {
        credentialsBinding {
          file('AWS_CONFIG_FILE', 'aws_config')
          string 'MWC_AWS_ACCESS_KEY', 'mobile-web-aasa-staging-deploy-key-id'
          string 'MWC_AWS_SECRET_KEY', 'mobile-web-aasa-staging-deploy-key-secret'
        }
    }
}

// Clean-deploy will fire this job
job {
    name 'mobile-web-aasa-deploy-production'
    using 'TEMPLATE-mobile-web-aasa-deploy'

    parameters {
        stringParam('BUCKET', 'twitch-mobile-static', 'bucket to hold static assets')
        stringParam('DISTRIBUTION', 'E2B6A3286NK3MQ', 'the CloudFront distribution to run invalidations on')
    }

    wrappers {
        credentialsBinding {
          file('AWS_CONFIG_FILE', 'aws_config')
          string 'MWC_AWS_ACCESS_KEY', 'mobile-web-aasa-prod-deploy-key-id'
          string 'MWC_AWS_SECRET_KEY', 'mobile-web-aasa-prod-deploy-key-secret'
        }
    }
}
