'use strict';

const path = require('path');
const process = require('process');
const webpack = require('webpack');

const fs = require('fs');

module.exports = {
  name: 'base',
  entry: {
    app: './src/device-identifier.ts',
  },
  target: 'web',
  output: {
    filename: 'index.js',
    devtool: 'cheap-source-map',
  },
  resolve: {
    extensions: ['', '.ts', '.tsx', '.js', '.jsx'],
    modulesDirectories: ['node_modules'],
    root: path.resolve(process.cwd(), 'src')
  },
  module: {
    loaders: [
      {
        test: /\.tsx?$/,
        loader: 'babel-loader!ts-loader',
        exclude: ['node_modules', 'dist'],
      },
      {
        test: /\.jsx?$/,
        loader: 'babel-loader',
        exclude: ['node_modules', 'dist'],
      },
    ],
  },
};

