job {
  name 'device-identifier'
  using 'TEMPLATE-autobuild'
  logRotator {
      daysToKeep(14)
  }
  wrappers {
    sshAgent 'git-aws-read-key'
		preBuildCleanup()
		timestamps()
    credentialsBinding {
      string('GITHUB_ACCESS_TOKEN', 'devtools-deployment-github-api-token')
      file('COURIERD_PRIVATE_KEY', 'courierd')
			file('AWS_CONFIG_FILE', 'aws_config')
		}

    environmentVariables {
    }
  }

  scm {
    git {
      remote {
        github 'mobile-web/device-identifier', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v -proxy'
    saveDeployArtifact 'mobile-web/device-identifier', '.manta/dist'
  }

  publishers {
    // from https://git-aws.internal.justin.tv/release/jenkins-jobs/blob/3018d18f578c13d02985ea507d709f07efd48b73/templates/autobuild.groovy#L18-L20
    githubCommitNotifier()

    //*********** Test Results ******************
    archiveJunit('.manta/test-results.xml') {
      allowEmptyResults()
      retainLongStdout()
    }
  }
}
