

export type OS = "Android" | "Windows" | "iOS" | "Other";

export class DeviceIdentity {
  constructor(
    private osType: OS
  ) {

  }

  isAndroid(): boolean {
    return this.osType === 'Android';
  }

  isIOS(): boolean {
    return this.osType === 'iOS';
  }

  isWindows(): boolean {
    return this.osType === 'Windows';
  }

  isMobile(): boolean {
    return this.isIOS() || this.isAndroid() || this.isWindows();
  }
}

export function identifyDevice(ua: string = navigator.userAgent): DeviceIdentity {
  let os: OS = 'Other';

  // Have to do Windows first even though it is the least likely. This is
  // because MS jammed a bunch of identifiers into their UA string to make
  // it look like it might be an Android or iOS device.
  if (ua.match(/Windows Phone/i)) {
    os = 'Windows';
  }
  else if (ua.match(/iPad/i) || ua.match(/iPhone/i) || ua.match(/iPod/)) {
    os = 'iOS';
  }
  else if (ua.match(/Android/i)) {
    os = 'Android';
  }
  return new DeviceIdentity(os);
}