# "${LAMBDA_NAME? Need the name of the lambda, LAMBDA_NAME}"
# "${STATEMENT_ID? Need the statement ID to assign this add permission to, STATEMENT_ID}"
# "${API_ACCOUNT? Need the account the API Gateway is in, API_ACCOUNT}"
# "${API_IDENTIFIER? Need the API identifier, API_IDENTIFIER}"
# "${ACTION? Need the action the API gateway will be responding to, ACTION}"
# "${RESOURCE? Need the resource the API Gateway will have received in the request, RESOURCE}"
echo "༼ つ ◕_◕ ༽つ Giving $API_IDENTIFIER/$ACTION/$RESOURCE access to $LAMBDA_NAME on account $API_ACCOUNT as $STATEMENT_ID."
aws lambda add-permission \
  --function-name $LAMBDA_NAME \
  --statement-id $STATEMENT_ID \
  --action lambda:InvokeFunction \
  --principal apigateway.amazonaws.com \
  --source-arn "arn:aws:execute-api:us-west-2:$API_ACCOUNT:$API_IDENTIFIER/*/$ACTION/$RESOURCE"
