variable "service_origin" {}

variable "service_path" {}

variable "static_bucket_domain" {}

variable "staging_domain_name" {}

variable "certificate_arn" {}

resource "aws_cloudfront_distribution" "mws_distribution" {
  enabled         = true
  is_ipv6_enabled = true

  logging_config {
    include_cookies = false
    bucket          = "twitch-mobile-dev-logs.s3.amazonaws.com"
  }

  aliases = ["${var.staging_domain_name}"]

  price_class = "PriceClass_100"

  restrictions {
    geo_restriction {
      restriction_type = "none"
    }
  }

  viewer_certificate {
    acm_certificate_arn      = "${var.certificate_arn}"
    ssl_support_method       = "sni-only"
    minimum_protocol_version = "TLSv1.1_2016"
  }

  origin {
    domain_name = "${var.service_origin}"
    origin_id   = "mws_origin"
    origin_path = "${var.service_path}"

    custom_origin_config = {
      origin_protocol_policy = "https-only"
      http_port              = "80"
      https_port             = "443"

      origin_ssl_protocols = [
        "TLSv1.1",
        "TLSv1.2",
      ]
    }
  }

  origin {
    domain_name = "${var.static_bucket_domain}"
    origin_path = "/.well-known"
    origin_id   = "well-known-directory"
  }

  origin {
    domain_name = "${var.static_bucket_domain}"
    origin_path = ""
    origin_id   = "static-resources"
  }

  default_cache_behavior {
    allowed_methods  = ["DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT"]
    cached_methods   = ["GET", "HEAD"]
    target_origin_id = "mws_origin"

    forwarded_values {
      query_string = true

      query_string_cache_keys = [
        "desktop-redirect",
        "fontsize",
        "theme",
        "tt_content",
        "tt_redirect",
      ]

      headers = ["Accept-Language"]

      cookies {
        forward           = "whitelist"
        whitelisted_names = ["language"]
      }
    }

    viewer_protocol_policy = "allow-all"
    min_ttl                = 0
    default_ttl            = 60
    max_ttl                = 60
  }

  cache_behavior {
    allowed_methods  = ["GET", "HEAD"]
    cached_methods   = ["GET", "HEAD"]
    target_origin_id = "static-resources"
    path_pattern     = "/.well-known/*"

    forwarded_values {
      query_string = false

      headers = []

      cookies {
        forward = "none"
      }
    }

    viewer_protocol_policy = "allow-all"
    min_ttl                = 0
    default_ttl            = 60
    max_ttl                = 60
  }

  cache_behavior {
    allowed_methods  = ["GET", "HEAD"]
    cached_methods   = ["GET", "HEAD"]
    target_origin_id = "static-resources"
    path_pattern     = "/static/*"

    forwarded_values {
      query_string = false

      headers = []

      cookies {
        forward = "none"
      }
    }

    viewer_protocol_policy = "allow-all"
    min_ttl                = 0
    default_ttl            = 60
    max_ttl                = 60
  }

  cache_behavior {
    allowed_methods  = ["GET", "HEAD"]
    cached_methods   = ["GET", "HEAD"]
    target_origin_id = "well-known-directory"
    path_pattern     = "/apple-app-site-association"

    forwarded_values {
      query_string = false

      headers = []

      cookies {
        forward = "none"
      }
    }

    viewer_protocol_policy = "allow-all"
    min_ttl                = 0
    default_ttl            = 60
    max_ttl                = 60
  }
}
