resource "aws_iam_role" "allow_api_gateway_to_assume_role" {
  name = "allowAPIGatewayToAssumeRoleForMWS"

  assume_role_policy = <<END_OF_ROLE
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "apigateway.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
END_OF_ROLE
}

resource "aws_iam_role_policy" "mws_gateway_execution" {
  name = "polyfillGatewayExecution"
  role = "${aws_iam_role.allow_api_gateway_to_assume_role.id}"

  policy = <<END_OF_POLICY
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "lambda:InvokeFunction"
            ],
            "Resource": "*"
        }
    ]
}
END_OF_POLICY
}

output "role_arn" {
  value = "${aws_iam_role.allow_api_gateway_to_assume_role.arn}"
}
