provider "aws" {
  region = "us-west-2"
}

provider "aws" {
  region = "ap-southeast-1"
  alias  = "ap-southeast-1"
}

module "mws_gateway_role" {
  source = "../modules/role"
}

module "mws_gateway_production_v2" {
  source                         = "../modules/gateway-better-redirect"
  aws_region                     = "us-west-2"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "production"
  lambda_name                    = "arn:aws:lambda:us-west-2:430230848193:function:channelViewer:PRODUCTION"
  gateway_name                   = "V2 Production MWS Gateway"
}

module "mws_gateway_production_v2_singapore" {
  source = "../modules/gateway-better-redirect"

  providers = {
    aws = "aws.ap-southeast-1"
  }

  aws_region                     = "ap-southeast-1"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "production"
  lambda_name                    = "arn:aws:lambda:ap-southeast-1:430230848193:function:mobileWebLambdaService:PRODUCTION"
  gateway_name                   = "V2 Singapore Production MWS Gateway"
}
