provider "aws" {
  region = "us-west-2"
}

provider "aws" {
  region = "ap-southeast-1"
  alias  = "ap-southeast-1"
}

module "mws_gateway_role" {
  source = "../modules/role"
}

module "mws_gateway" {
  source                         = "../modules/gateway-better-redirect"
  aws_region                     = "us-west-2"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "staging"
  lambda_name                    = "arn:aws:lambda:us-west-2:931523683592:function:channelViewer:STAGING"
  gateway_name                   = "MWS Gateway: Public"
}

module "mws_gateway_cap" {
  source                         = "../modules/gateway-better-redirect"
  aws_region                     = "us-west-2"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "cap"
  lambda_name                    = "arn:aws:lambda:us-west-2:931523683592:function:channelViewer:CAP"
  gateway_name                   = "MWS Gateway: Cap Kingdom"
}

module "mws_gateway_cascade" {
  source                         = "../modules/gateway-better-redirect"
  aws_region                     = "us-west-2"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "cascade"
  lambda_name                    = "arn:aws:lambda:us-west-2:931523683592:function:channelViewer:CASCADE"
  gateway_name                   = "MWS Gateway: Cascade Kingdom"
}

module "mws_gateway_sand" {
  source                         = "../modules/gateway-better-redirect"
  aws_region                     = "us-west-2"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "sand"
  lambda_name                    = "arn:aws:lambda:us-west-2:931523683592:function:channelViewer:SAND"
  gateway_name                   = "MWS Gateway: Sand Kingdom"
}

module "mws_gateway_lake" {
  source                         = "../modules/gateway-better-redirect"
  aws_region                     = "us-west-2"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "lake"
  lambda_name                    = "arn:aws:lambda:us-west-2:931523683592:function:channelViewer:LAKE"
  gateway_name                   = "MWS Gateway: Lake Kingdom"
}

module "mws_gateway_wooded" {
  source                         = "../modules/gateway-better-redirect"
  aws_region                     = "us-west-2"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "wooded"
  lambda_name                    = "arn:aws:lambda:us-west-2:931523683592:function:channelViewer:WOODED"
  gateway_name                   = "MWS Gateway: Wooded Kingdom"
}

module "mws_gateway_cloud" {
  source = "../modules/gateway-better-redirect"

  providers = {
    aws = "aws.ap-southeast-1"
  }

  aws_region                     = "ap-southeast-1"
  gateway_invoke_lambda_role_arn = "${module.mws_gateway_role.role_arn}"
  api_stage                      = "cloud"
  lambda_name                    = "arn:aws:lambda:ap-southeast-1:931523683592:function:mobileWebLambdaService:CLOUD"
  gateway_name                   = "MWS Gateway: Cloud Kingdom (Singapore)"
}

module "upsell_gateway" {
  source     = "../modules/upsellGateway"
  aws_region = "us-west-2"
  api_stage  = "staging"
}
