# Mobile Web Documentation

This is the mono repo for the mobile web codebase. This repo uses [lerna](https://github.com/lerna/lerna) and
[yarn](https://github.com/yarnpkg/yarn) workspaces to manage multiple projects relevant to mobile web.

* TOC
{:toc}

## Packages

<dl>
  <dt>mobile-web :: <a href="/packages/mobile-web">Source</a> | <a href="https://git-aws.internal.justin.tv/pages/mobile-web/channel-lambda/packages/mobile-web/">Documentation</a></dt>
  <dd>Mobile web codebase that powers the mobile web client, lambda backend, and dev server.</dd>
</dl>

## Getting Started

### Installing Dependencies

Check out the repository and run the [firstTime](/scripts/firstTime) script to make sure that all necessary dependencies are installed. This script is idempotent, and it is occasionally useful to re-run to verify that no new dependencies are missing.

```
git clone https://git-aws.internal.justin.tv/mobile-web/channel-lambda.git
cd channel-lambda
./scripts/firstTime
```

Once complete, follow the instructions in the development package being worked on for additional setup.

At this time, the only development package is [mobile-web](https://git-aws.internal.justin.tv/pages/mobile-web/channel-lambda/packages/mobile-web/).

### Configuring _/etc/hosts_

#### Localhost

The development tooling assumes that the development server will be running at [localhost.m.twitch.tv:3003](http://localhost.m.twitch.tv:3003).

If this is not already accessible, add the following to _/etc/hosts_.

```
127.0.0.1  localhost.m.twitch.tv
```

#### Staging

[staging.m.twitch.tv](https://staging.m.twitch.tv) is only available from the _justin.tv_ network; however, the domain is an alias for a CloudFront instance and can be accessed by IP.

In order to reach the domain from the _wpa2_ network, add the following to _/etc/hosts_.

```
13.32.153.174  staging.m.twitch.tv
```

In addition to [staging.m.twitch.tv](https://staging.m.twitch.tv), there is a public staging site, [public.staging.m.twitch.tv](https://public.staging.m.twitch.tv), that can be used when access is necessary from outside the Amazon network. This should be used sparingly and should not be given to **_any_** outsiders.

## Infrastructure

The infrastructure is described in an [architecture document](https://docs.google.com/a/justin.tv/document/d/10eR2UpK-FL8wjgjgAGKiOubu47ZrQGgxmuTnThf0vPg/edit?usp=sharing).

## Accessing Logs

See the [deploy runbook](https://wiki.twitch.com/display/ENG/Deploy+Runbook#DeployRunbook-AccessingLogs)
for detailed instructions on how to access logs.

## Deploying the Site

See the [deploy runbook](https://wiki.twitch.com/display/ENG/Deploy+Runbook)
for detailed instructions on how to deploy to
[staging](https://staging.m.twitch.tv) or [production](https://m.twitch.tv).

