'use strict';

const polyfill = require('../../../../lib');
const sources = require('../../../../lib/sources');
const PolyfillSet = require('../../../../service/PolyfillSet');

function handler(event, context, callback) {
  const minify = event.minify;
  const uaString = event.queriedUserAgent || event.userAgent;
  console.info(
    `Handling polyfill request for ${uaString} for ${event.features} with ${event.flags} excluding ${event.excludes}`
  );
  const flags = event.flags ? event.flags.split(',') : [];
  const polyfills = PolyfillSet.fromQueryParam(event.features, flags);
  const excludes = event.excludes ? event.excludes.split(',') : [];
  const varyUserAgent = !!event.queriedUserAgent;
  console.info(`Available polyfills include: ${sources.listPolyfillsSync().length}`);
  polyfill.getPolyfillString({
    features: polyfills.get(),
    rum: false,
    stream: false,
    excludes,
    minify,
    uaString,
  }).then((content) => {
    callback(
      null,
      {
        vary: varyUserAgent ? 'User-Agent' : '',
        content,
      }
    ); 
  });
}

exports.handler = handler;
