const UA = require('../../../../lib/UA');

/**
 * Lambda handler function that will normalize a user agent
 * string provided in the event & return it upon success.
 *
 * Primary use case is in Cloudfront's Lambda@Edge. This
 * has very strict requirements in terms of memory (128MB)
 * and time to execute. As such, it is good to keep This
 * code straightforward & with very little cruft.
 */
function handler(event, context, callback) {
  let request = event.Records[0].cf.request;
  let userAgent = request.headers['user-agent'][0];
  request.headers['original-user-agent'] = [userAgent];
  request.headers['user-agent'][0] = UA.normalize(userAgent);
  callback(null, request);
}

exports.handler = handler;
