variable "lambda_arn" {}

variable "warn_arns" {
  default = []
}

variable "error_arns" {
  default = []
}

resource "aws_cloudwatch_metric_alarm" "polyfill-taking-kinda-long" {
  alarm_name                = "polyfill-taking-kinda-long"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "3"
  metric_name               = "Duration"
  namespace                 = "AWS/Lambda"
  period                    = "60"
  statistic                 = "Average"
  threshold                 = "200"
  alarm_description         = "The polyfill service is taking an oddly long time."
  insufficient_data_actions = []
  ok_actions                = ["${var.warn_arns}"]
  alarm_actions             = ["${var.warn_arns}"]
  dimensions                = {
    FunctionName = "${var.lambda_arn}"
  }
}

resource "aws_cloudwatch_metric_alarm" "polyfill-taking-very-long" {
  alarm_name                = "polyfill-taking-very-long"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "3"
  metric_name               = "Duration"
  namespace                 = "AWS/Lambda"
  period                    = "60"
  statistic                 = "Average"
  threshold                 = "2000"
  alarm_description         = "The polyfill service is taking a very long time."
  insufficient_data_actions = []
  ok_actions                = ["${var.error_arns}"]
  alarm_actions             = ["${var.error_arns}"]
  dimensions                = {
    FunctionName = "${var.lambda_arn}"
  }
}
