'use strict';

var nodeExternals = require('webpack-node-externals');

module.exports = {
  entry: './index.js',
  target: 'node',
  output: {
    path: './lib',
    filename: 'index.js',
    library: "index",
    libraryTarget: 'commonjs2'
  },
  node: {
    __dirname: false,
    __filename: false,
  },
  resolve: {
    extensions: ['', '.js', '.json']
  },
  externals: nodeExternals(),
  module: {
    loaders: [
      {
        test: /\.js$/,
        loader: 'babel',
        exclude: [/node_modules/],
        query: {
          presets: ['es2015'],
        },
      },
      {
        test: /\.json$/,
        loader: 'json-loader'
      }
    ],
  },
};
