export namespace regex {
  export const IsValidDomain = new RegExp('twitch\.(tv|tech)$', 'i');

  export const IsProductionSage = new RegExp('(go|rc|canary|release|www)\.twitch\.tv', 'i')
  export const IsCoreJS = new RegExp('\.twitchcdn\.net\/assets\/core-.*\.js', 'i');
  export const IsSettingsJS = new RegExp('\.twitchcdn\.net\/config\/settings.*\.js', 'i');
  export const IsManifestJS = new RegExp('\.twitchcdn\.net\/assets\/manifest-.*\.js', 'i');
  export const IsVendorJS = new RegExp('\.twitchcdn\.net\/assets\/vendor-.*\.js', 'i');
  export const IsCoreCSS = new RegExp('\.twitchcdn\.net\/assets\/core-.*\.css', 'i');
  export const IsWorkerJS = new RegExp('\.twitchcdn\.net\/assets\/worker-.*\.js', 'i');
  export const IsPageJS = new RegExp('\.twitchcdn\.net\/assets\/pages\.(.*)-[^-.]+\.js', 'i');
  export const IsEntryJS = new RegExp('\.twitchcdn\.net\/assets\/entry\.(.*)-[^-.]+\.(js|css)', 'i');
  export const IsLocalesJS = new RegExp('\.twitchcdn\.net\/assets\/(?:core\.locales|messages)\.(.*)-[^-.]+\.js', 'i');
  export const IsPolyfillJS = new RegExp('\.twitchsvc\.net\/v2\/polyfill.*\.js', 'i');
  export const IsFavicon = new RegExp('\.twitchcdn\.net\/assets\/favicon-.*', 'i');
  export const IsTwilightImage = new RegExp('\.twitchcdn\.net/assets/(.*)-[^-.]+\.(png|jpg)', 'i');
  export const IsSentinel = new RegExp('sentinel\.twitchsvc\.net', 'i');
  export const IsCustos = new RegExp('custos\.twitchcdn\.net\/.*\.js', 'i');

  export const IsClientReporter = new RegExp('client-event-reporter\.twitch\.tv', 'i');
  export const IsJtvnw = new RegExp('(static-cdn|s)\.jtvnw.net/([^/]*)/.*', 'i');

  export const IsGraphQL = new RegExp('(api|gql)\.twitch(svc)?\.(tv|net)/gql', 'i');
  export const IsKraken = new RegExp('api\.twitch(svc)?\.(tv|net)/([^/]+)', 'i');
  export const IsViewerToken = new RegExp('api\.twitch(svc)?\.(tv|net)/api/viewer/token\.json', 'i');
  export const IsAPIMe = new RegExp('api\.twitch(svc)?\.(tv|net)/api/me', 'i');

  export const IsPlayerJS = new RegExp('player.js', 'i');
  export const IsPlayerCSS = new RegExp('player.css', 'i');
  export const IsPlayerOther = new RegExp('player\.twitch\.tv/', 'i');

  export const IsClipsMediaAssets = new RegExp('clips-media-assets\.twitch\.tv', 'i');
  export const IsVodStoryboards = new RegExp('vod-storyboards\.twitch\.tv', 'i');
  export const IsPubSub = new RegExp('pubsub-edge\.twitch\.tv', 'i');
  export const IsPubster = new RegExp('pubster\.twitch\.tv', 'i');
  export const IsIRC = new RegExp('irc-ws\.chat\.twitch\.tv', 'i');
  export const IsClips = new RegExp('clips\.twitch\.tv', 'i');

  export const IsAkamai = new RegExp('static-a\.twitchcdn\.net', 'i');
  export const IsCloudFront = new RegExp('static-cf\.twitchcdn\.net', 'i');
  export const IsCloudFlare = new RegExp('static-cfl\.twitchcdn\.net', 'i');
  export const IsFastly = new RegExp('static-f\.twitchcdn\.net', 'i');
  export const IsControl = new RegExp('static\.twitchcdn\.net', 'i')
}