import * as AWS from 'aws-sdk';
const AWSJS = require('aws-sdk');
import * as path from 'path';
import { SpudConfigOpts } from './src/config';
import makeProcessor from './src/processor';

AWS.config.update({
  region: process.env.AWS_REGION,
  // Default SDK timeout is 2 minutes which is longer than a lambda function's life
  // Set this to 5s/10s to allow retries a chance to work
  maxRetries: 6,
  httpOptions: {
    connectTimeout: 5000,
    timeout: 10000,
  }
});

// Retry on `Throttle`
AWSJS.events.on('retry', function (resp: any) {
  if (resp.error && resp.error.code === 'Throttling') {
    resp.error.retryable = true;
  }
});

const { events: { namespace, handled_events } } = require('./config/spud.json');

const eventHandlers = handled_events.reduce((acc: SpudConfigOpts['eventHandlers'], event: string) => {
  const config = require(`./config/spade_events/${event}.toml`)
  if (config.handler) {
    config.handler = require(`./config/spade_events/models/${event}`).default
  }

  acc[event] = config
  return acc;
}, {})

export const processRecords = makeProcessor({ namespace, eventHandlers })

