import AWS = require('aws-sdk');
import fs = require('fs');
import { GetRecordsOutput } from 'aws-sdk/clients/kinesis';

const stage = process.argv[2] ? process.argv[2] : 'dev'
const conf = JSON.parse(fs.readFileSync('./config/spud.json', 'utf8'))[stage];

process.env.AWS_PROFILE = conf.aws_profile;
process.env.AWS_REGION = conf.aws_region;

const STREAM = conf.kinesis_arn.split('/').pop()

async function getLatestData() {
  let output: GetRecordsOutput = { Records: [] };
  const kinesis: AWS.Kinesis = new AWS.Kinesis({ params: { StreamName: STREAM, Limit: 100 } });
  const stream = await kinesis.describeStream({ StreamName: STREAM }).promise()
  const shardId = stream.StreamDescription.Shards[0].ShardId
  const iterator = await kinesis.getShardIterator({ ShardId: shardId, ShardIteratorType: 'LATEST', StreamName: STREAM }).promise()

  if (!iterator.ShardIterator) { throw "no iterator found" }

  let data: GetRecordsOutput = { Records: [] }
  let shardIterator = iterator.ShardIterator
  while (output.Records.length < 50) {
    data = await kinesis.getRecords({ ShardIterator: shardIterator, Limit: 100 }).promise()
    output.Records = output.Records.concat(data.Records)
    shardIterator = data.NextShardIterator as string
  }

  return output
}

getLatestData().then(function (o) {
  let output: any = { Records: [] };

  output.Records = o.Records.map(r => {
    return {
      kinesis: r
    }
  });

  output.Records.map((r: any) => r.kinesis.data = r.kinesis.Data.toString('base64'));
  output.Records.map((r: any) => delete r.kinesis.Data);
  console.log(JSON.stringify(output))
});