import { MetricID } from "./metric_id";
import { SEH1 } from "./seh1";
import { Sample, CloudWatchUnit } from "./sample";

// Distribution is like a Sample, but instead of representing
// a single datapoint it represents a group of aggregated datapoints.
// The timestamp should be the time at which the first sample was
// ingested into the distribution.
//
// Many samples can be fed into a SampleAggregator,
// and the output is one Distribution per unique metric
//
// TODO: should this be converted to an interface w/ an implementation for
// more flexibility?

export class Distribution {
  MetricID: MetricID;
  Unit: CloudWatchUnit;
  RollupDimensions: string[][];
  Timestamp: Date;

  SampleCount: number = 0;
  Maximum: number = 0;
  Minimum: number = 0;
  Sum: number = 0;
  SEH1: SEH1 = new SEH1();

  public constructor(s: Sample) {
    this.MetricID = s.MetricID;
    this.Unit = s.Unit;
    this.RollupDimensions = s.RollupDimensions || [[]];
    this.Timestamp = s.Timestamp;

    this.addSample(s)
  }

  // AddSample Adds a sample to this distribution. Does not do any validation
  // that the Metric in the sample matches the Metric in the Distribution!
  public addSample(s: Sample) {
    // Incorporate sample's value into this distribution
    if (this.SampleCount == 0 || this.Minimum > s.Value) {
      this.Minimum = s.Value;
    }
    if (this.SampleCount == 0 || this.Maximum < s.Value) {
      this.Maximum = s.Value;
    }

    this.SampleCount++;
    this.Sum += s.Value;
    this.SEH1.include(s);
  }
}