import { strict as assert } from 'assert';
import 'mocha';

import { filters } from './filters';
import { ConsoleLogger } from './log-aggregator';
import { SpadeEventFields } from "./spade_event_data";

const logger = new ConsoleLogger()

describe('Filters', () => {
    describe('testAll', () => {
        const fields: SpadeEventFields = {
            time: '23456789',
            time_utc: '12345678',
            continent: 'North America',
            country: 'US',
            region: '',
            city: 'Seattle',
            foo: 'bar',
        }

        it('should work with an array filter', () => {
            assert(filters.testAll(fields, {equal: {foo: ['bar', 'baz']}}, logger))
        })
        it('should reject with an non-matching array', () => {
            assert(!filters.testAll(fields, {equal: {foo: ['too', 'far']}}, logger))
        })
    })

    describe('test', () => {
        describe('equal', () => {
            it('should fail if values differ', () => {
                assert(!filters.test('equal', 'foo', 'bar', logger))
            })

            it('should pass if values match', () => {
                assert(filters.test('equal', 'foo', 'foo', logger))
            })

            it('should pass if filter is a string and data is a number', () => {
                assert(filters.test('equal', '5', 5, logger))
            })

            it('should accept a value in the array', () => {
                assert(filters.test('equal', ['foo', 'bar'], 'bar', logger))
            })

            it('should reject a value not in the array', () => {
                assert(!filters.test('equal', ['foo', 'bar'], 'baz', logger))
            })
        })
    })

})
