// Country Names
// From MaxMind
export class CountryName {
  constructor(readonly country_code: string, readonly name: string) { }
}

export const countryNameMap: { [country_code: string]: CountryName } = {}
const countryNameData = require('./data/country_names.csv')

for (let country of countryNameData) {
  countryNameMap[country[0]] = new CountryName(country[0], country[1])
}

// Region Data
// From MaxMind
export class Region {
  constructor(readonly country_code: string, readonly region_code: string, readonly region_name: string) { }
}

export const regionMap: { [code: string]: Region } = {};
const regionData = require('./data/regions.csv');

for (let region of regionData) {
  regionMap[`${region[0]}:${region[1]}`] = new Region(region[0], region[1], region[2]);
}
