export interface Logger {
    log(message:string): void;
}

export class LogAggregator {
    private logMap: { [key: string]: number } = {}

    log(message: string) {
        if (this.logMap[message]) {
            this.logMap[message]++
        } else {
            this.logMap[message] = 1
        }
    }

    flush() {
        Object.keys(this.logMap).forEach(message => {
            const count = this.logMap[message]
            console.log(`[${count}] ${message}`)
        })
    }
}

export class ConsoleLogger {
    log(message: string) {
        console.log(message)
    }
}
