export interface DimensionSet {
  [name: string]: string
}


export class MetricID {
  Name: string;
  Dimensions: DimensionSet;

  constructor(name: string) {
    this.Name = name;
    this.Dimensions = {};
  }

  public addDimension(name: string, value: string) {
    this.Dimensions[name] = value;
  }

  public withDimension(name: string, value: string): MetricID {
    this.addDimension(name, value)
    return this
  }
}