import { MetricID } from "./metric_id";

export type CloudWatchUnit = "Seconds" | "Microseconds" | "Milliseconds" | "Bytes" | "Kilobytes" | "Megabytes" | "Gigabytes" | "Terabytes" | "Bits" | "Kilobits" | "Megabits" | "Gigabits" | "Terabits" | "Percent" | "Count" | "Bytes/Second" | "Kilobytes/Second" | "Megabytes/Second" | "Gigabytes/Second" | "Terabytes/Second" | "Bits/Second" | "Kilobits/Second" | "Megabits/Second" | "Gigabits/Second" | "Terabits/Second" | "Count/Second" | "None";

export interface Sample {
  // Metric holds information that uniquely identifies the Metric that this sample belongs to. Namely,
  // the Metric contains the (Name, DimensionSet) of this Sample
  MetricID: MetricID;

  // RollupDimensions is an optional list of rollup dimension key sets.
  // Example:
  // RollupDimensions = [][]string {
  //     []string {"Domain"},
  //     []string {"Domain", "Operation"},
  // }
  // Given a MetricID.Dimensions with values for ServiceName, Operation, and Domain,
  // the final dimensions to send for this RollupDimensions would be:
  // []DimensionSet {
  //     DimensionSet {
  //         "ServiceName": "MyService",
  //         "Operation": "DoStuff",
  //         "Domain": "Foo",
  //     },
  //     DimensionSet {
  //         "ServiceName": "MyService",
  //         "Operation": "DoStuff",
  //     },
  //     DimensionSet {
  //         "ServiceName": "MyService",
  //     },
  // }
  RollupDimensions?: string[][];

  // Timestamp is the time that this sample was obtained.
  Timestamp: Date;

  // Value for the sample.
  Value: number;

  // Unit of the sample value.  Use CloudWatch unit values.
  Unit: CloudWatchUnit;
}