import pako = require('pako');

import { Logger } from "./log-aggregator";
import { SpadeEventData } from './spade_event_data';
import { SpudConfig } from './config';
import SpadeDataPoint from './spade_data_point';
import { Sample } from './sample';

export class SpadeEvent {
  logger: Logger
  dataPoints: SpadeDataPoint[] = [];
  config: SpudConfig;

  constructor(config:SpudConfig, logger: Logger) {
    this.config = config
    this.logger = logger
  }

  public async populateDataPoints(encodedData: string) {
    const rawData = JSON.parse(Buffer.from(encodedData, 'base64').toString('ascii')).Data;
    const data = pako.inflate(Buffer.from(rawData, 'base64').slice(1), { windowBits: -15, to: 'string' });

    if (process.env.IS_LOCAL && process.env.PRINT_KINESIS) {
      console.log(JSON.stringify(JSON.parse(data), null, 2))
    }

    this.dataPoints = JSON.parse(data).reduce((acc: SpadeDataPoint[], dataPoint: SpadeEventData) => {
      const event_config = this.config.getEventConfig(dataPoint.Name);

      if (event_config) {
        const Handler = event_config.handler || SpadeDataPoint;
        acc.push(new Handler(event_config, dataPoint.Fields, this.logger));
      }

      return acc;
    }, [])
  }

  public toSamples(): Sample[] {
    // flatten array one level deep
    return [].concat.apply([], this.dataPoints.map(d => d.toSamples()))
  }
}
