## Description

(Replace this sentence with a high-level summary of this change and explain how
and why any critical decisions were made.)

#### Link to Issue: https://jira.twitch.com/browse/REPLACE-ME

#### For package work:

- [ ] Any package changes include corresponding updates to the CHANGELOG

#### [Risk Assessment](https://docs.google.com/spreadsheets/d/17i1TmEsx6idJ6iYcTi-dAtfY9R_iFB9WIKWl2ePk9cc/edit#gid=659333091): (low, medium, or high)

#### Contributing Team Checklist

- [ ] My team understands and acknowledges that Tachyon is a shared space and
      agrees to the
      [Tachyon Feature Ownership Policy](./policies/feature-ownership.md).
- [ ] Reviewed by a member of my team.
- [ ] Reviewed by the Core Platforms team (add the "Ready for Review" label to
      trigger Orko notifications).

## Success Criteria

### Manual QA Instructions

[Staging verification:](https://git.xarth.tv/pages/emerging-platforms/tachyon/d/apps/tomorrow/processes/using-staging-environments/)

- [ ] For https://<staging-name>.mweb-staging.xarth.tv/<path>, do <steps> and
      expect <result>
- [ ] For ...

### Screenshots (For all non-trivial UI changes)

#### Mobile-Web

Phone Portrait:

Phone Landscape:

Tablet Portrait:

Tablet Landscape:

#### Starshot (preferably provide at least one shot of 720p as well as 1080p)

Modern Chrome:

Chromium-38:

### For New Tomorrow Features And High Risk Changes

Adheres to Tomorrow's
[support policy](https://git.xarth.tv/pages/emerging-platforms/tachyon/d/apps/tomorrow/policies/browser-support/):

- [ ] works on
      [iOS 9.3+](https://git.xarth.tv/pages/emerging-platforms/tachyon/d/apps/tomorrow/processes/device-testing/#setting-up-an-ios-simulator)
- [ ] works on
      [Android 5.1+](https://git.xarth.tv/pages/emerging-platforms/tachyon/d/apps/tomorrow/processes/device-testing/#setting-up-an-android-simulator)

### Helpful Links

[Markdown Autofix Task](https://teamcity.internal.justin.tv/buildConfiguration/EmergingPlatforms_Tachyon_CIPrettierMarkdown)
[Re-Run Full CI Task](https://teamcity.internal.justin.tv/buildConfiguration/EmergingPlatforms_Tachyon_CIFullCISuite)
[Using Public Staging Environments](https://git.xarth.tv/pages/emerging-platforms/tachyon/d/processes/using-public-staging-environments/)
[Code Review - The Emoji Code](https://devblogs.microsoft.com/appcenter/how-the-visual-studio-mobile-center-team-does-code-review/#introducing-the-emoji-code)
