# Tachyon Repo Changelog

## 33.0.0 (pending)

- Updated to use Typescript 4.4 and converted packages to use
  `exactOptionalPropertyTypes`
  [PR 4970](https://git.xarth.tv/emerging-platforms/tachyon/pull/4970)
- Adds `PulsarBackend` export type. Maps to "backend" values commonly used in
  player tracking events but can be used for other use cases as well.
  [PR 4989](https://git.xarth.tv/emerging-platforms/tachyon/pull/4989)
- Add `forceServerPreRoll` option to `createStreamManifestUrl`
  [PR 4988](https://git.xarth.tv/emerging-platforms/tachyon/pull/4988)

### pulsar-bitmovin

- removed and no longer used
  [PR 4987](https://git.xarth.tv/emerging-platforms/tachyon/pull/4987)

### pulsar-hlsjs

- Support starting a VOD at a given start time
  [PR 4945](https://git.xarth.tv/emerging-platforms/tachyon/pull/4945)
- Emits a NOT_SUPPORTED player error prior to playback if MSE is not supported
  in the browser
  [PR 4961](https://git.xarth.tv/emerging-platforms/tachyon/pull/4961)

### pulsar-native

- Support starting a VOD at a given start time
  [PR 4945](https://git.xarth.tv/emerging-platforms/tachyon/pull/4945)
- Emits a NOT_SUPPORTED player error prior to playback if HLS is not supported
  in the browser
  [PR 4961](https://git.xarth.tv/emerging-platforms/tachyon/pull/4961)

## pulsar-player-core

- Removed deprecated props: `onAutoplayFailed`, `onContentBuffering`,
  `onContentChange`, `onContentEnd`, `onContentPlaying`, `onContentRestriction`,
  `onError`, `onUnmute`. `params` is now optional to support early render
  patterns [PR 4978](https://git.xarth.tv/emerging-platforms/tachyon/pull/4978)
- Removed `options` field from `VideoParams` and update PulsarCore to use
  `startTime` from PulsarProps
  [PR 4945](https://git.xarth.tv/emerging-platforms/tachyon/pull/4945)
- Removed legacy tracking types and fields no longer used `ContentGame`,
  `Viewer`, and `host` and `stream` from `StreamParams`
  [PR 4996](https://git.xarth.tv/emerging-platforms/tachyon/pull/4996)

### pulsar-restrictions

- created new `pulsar-restrictions` package to move existing playback
  restrictions system (`useChannelRestrictions`, etc) out of
  `tachyon-page-utils` into a standalone package.
  [PR 4967](https://git.xarth.tv/emerging-platforms/tachyon/pull/4967)

### pulsar-shaka

- Removed and no longer used
  [PR 4955](https://git.xarth.tv/emerging-platforms/tachyon/pull/4955)

### pulsar-utils

- Adds `browserSupportsMSE` to check if current browser supports MSE
  [PR 4961](https://git.xarth.tv/emerging-platforms/tachyon/pull/4961)
- Adds resolution capping support (720p30/60) to `createManifestUrl` helper via
  new `maxResolution` option
  [PR 4976](https://git.xarth.tv/emerging-platforms/tachyon/pull/4976)
- Allow `src` on `PulsarProps` to be nullable to enable earliy library
  initialization
  [PR 4948](https://git.xarth.tv/emerging-platforms/tachyon/pull/4948)
- now contains `hasCaptionsEnabledCookie`, `setCaptionsCookie `,
  `lacksMatureCookie`, `setMatureCookie` which were previously in
  `tachyon-page-utils`
  [PR 4967](https://git.xarth.tv/emerging-platforms/tachyon/pull/4967)
- adds `max_height`, `max_width`, `max_framerate`, and `removeAudioOnlyPlaylist`
  to Stream / VOD manifest URL builders
  [PR 5000](https://git.xarth.tv/emerging-platforms/tachyon/pull/5000)

### pulsar-videojs

- Removed and no longer used
  [PR 4955](https://git.xarth.tv/emerging-platforms/tachyon/pull/4955)

### tachyon-dynamic-settings

- `fetchDynamicSettings` updated with stricter types, enforcing the opinion of
  snake-cased raw settings and camel-cased processed settings
  [PR 4991](https://git.xarth.tv/emerging-platforms/tachyon/pull/4991)

### tachyon-event-reporter

- `TwitchEvent` moved to `tachyon-type-library`
  [PR 4971](https://git.xarth.tv/emerging-platforms/tachyon/pull/4971)

### tachyon-more-ui

- Removed `SoundCloudSvg` and `SpotifySvg` which are provided by Core UI.
  [PR 4965](https://git.xarth.tv/emerging-platforms/tachyon/pull/4965)

### tachyon-page-utils

- DX and clarity update: `channelPageviewTracking` function name updated to
  `channelWatchPageviewTracking`; `channelGetInitialProps` renamed to
  `channelPathGetInitialProps` and accepts optional query variables;
  `channelVodsGetInitialProps`, `clipGetInitialProps`, `gameGetInitialProps`,
  and `vodGetInitialProps` also now accept optional query variables;
  `channelProfilePageviewTracking` removed (previously replaced by
  `channelHomePageviewTracking`); adds new `channelAboutPageviewTracking`
  [PR 4952](https://git.xarth.tv/emerging-platforms/tachyon/pull/4952)
- Add `useStartTime` to calculate the start time for a VOD.
  [PR 4945](https://git.xarth.tv/emerging-platforms/tachyon/pull/4945)
- Add context based hook for handling restrictions in `usePlaybackRestrictions`
  hook and accompanying contexts, `ChannelPlaybackRestrictionsRoot`,
  `ClipPlaybackRestrictionsRoot`, and `VodPlaybackRestrictionsRoot`
  [PR 4928](https://git.xarth.tv/emerging-platforms/tachyon/pull/4928)
- removed playback restriction exports (`useChannelRestrictions`, etc). Access
  via the top-level `pulsar` re-export package or `pulsar-restrictions` package.
  [PR 4967](https://git.xarth.tv/emerging-platforms/tachyon/pull/4967)

### tachyon-report-wizard

- Change wizard title to 'Report USERNAME' on content step
  [PR 4956](https://git.xarth.tv/emerging-platforms/tachyon/pull/4956)
- Update report wizard logic to map contents over schema's new reportReason
  field [PR 4964](https://git.xarth.tv/emerging-platforms/tachyon/pull/4964)
- Fix flashing of form preview during netzDG related transition
  [PR 4960](https://git.xarth.tv/emerging-platforms/tachyon/pull/4960)

### tachyon-utils-ts

- exports helpers `ensureBoolean`, `ensureNumber`, `ensureString`,
  `ensureNumberArray`, and `ensureStringArray` for convenience of common usecase
  of typeguards
  [PR 4991](https://git.xarth.tv/emerging-platforms/tachyon/pull/4991)

### tachyon-tv-nav

- remove swipe controls
  [PR 4941](https://git.xarth.tv/emerging-platforms/tachyon/pull/4941)

### tachyon-type-library

- Exports `TwitchEvent` and `TwitchEventProperties` to allow for propagating a
  single event shape throughout packages
  [PR 4971](https://git.xarth.tv/emerging-platforms/tachyon/pull/4971)
- Exports `OnlySnakeCaseProperties` utility for removing all camel- and
  kebab-cased properties from an object type
  [PR 4991](https://git.xarth.tv/emerging-platforms/tachyon/pull/4991)

### twitch-chat-client

- Add support for `communityintroduction` user notice
  [PR 4999](https://git.xarth.tv/emerging-platforms/tachyon/pull/4999)

## 32.0.0 (September 20, 2021)

### general

- all React peer dependencies fixed from `>16.14.0` to `>=16.14.0`
  [PR 4801](https://git.xarth.tv/emerging-platforms/tachyon/pull/4801)

### pulsar-bitmovin

- Add new `pulsar-bitmovin` package that provides a Pulsar API for the Bitmovin
  player [PR 4908](https://git.xarth.tv/emerging-platforms/tachyon/pull/4908)

### pulsar-core

- renaming `initialMuted`, `initialVolume`, and `nativeControls` to
  HTMLVideoElement prop equivalent as part of standardizing Pulsar Props across
  players and simplifying mapping logic
  [PR 4792](https://git.xarth.tv/emerging-platforms/tachyon/pull/4792)
- removed `mainManifestUrl` from the `params` prop object, specify a `src` level
  prop (consistent with other Pulsar backends) instead to provide a custom
  manifest url
  [PR 4828](https://git.xarth.tv/emerging-platforms/tachyon/pull/4828)
- removed the deprecated `onTrackingEvent` prop, removed the `useTrackingEffect`
  hook, and cleaned up unused content param fields.
  [PR 4889](https://git.xarth.tv/emerging-platforms/tachyon/pull/4889)

### pulsar-hlsjs

- Add new `pulsar-hlsjs` package that provides a Pulsar API for HLS.js
  [PR 4833](https://git.xarth.tv/emerging-platforms/tachyon/pull/4833)

### pulsar-native

- Adds `createNativePlayerController`
  [PR 4814](https://git.xarth.tv/emerging-platforms/tachyon/pull/4818)

### pulsar-player-controller

- Add `Initializing` playback state
  [PR 4741](https://git.xarth.tv/emerging-platforms/tachyon/pull/4741)
- Integrates PulsarShaka into the player controller API
  [PR 4667](https://git.xarth.tv/emerging-platforms/tachyon/pull/4667)
- Adds `emitEvent` to `createNativePlayerController` allowing for controller
  creators to augment the base event system
  [PR 4809](https://git.xarth.tv/emerging-platforms/tachyon/pull/4809)
- Provides only the base APIs for player-controller composition and moves out
  the `createNativePlayerController` function
  [PR 4814](https://git.xarth.tv/emerging-platforms/tachyon/pull/4818)

### pulsar-player-core

- update styling for container and video tag to work with Chrome 38
  [PR 4721](https://git.xarth.tv/emerging-platforms/tachyon/pull/4721)

### pulsar-utils

- Add `formatVideoQualityName` for formatting video quality names in this
  format: `{height}p{framerate}`
  [PR 4667](https://git.xarth.tv/emerging-platforms/tachyon/pull/4667)
- Add custom type declarations for the m3u8-parser library to type the data we
  currently consume.
  [PR 4848](https://git.xarth.tv/emerging-platforms/tachyon/pull/4848)
- refactor manifest URL generator utils to take playerType rather than flags
  used to create a playerType for greater flexibility on the consumer end
  [PR 4851](https://git.xarth.tv/emerging-platforms/tachyon/pull/4851)
- removed unused fields returned from `clipPulsarParams`, `vodPulsarParams`, and
  `parseChannelPulsarParams`
  [PR 4889](https://git.xarth.tv/emerging-platforms/tachyon/pull/4889)

### pulsar-videojs

- Add new `pulsar-videojs` package that provides a Pulsar API for Video.js
  [PR 4893](https://git.xarth.tv/emerging-platforms/tachyon/pull/4893)

### tachyon-auth

- Removes `skipOnLoginCallback` as an optional argument from the context API
  [PR 4755](https://git.xarth.tv/emerging-platforms/tachyon/pull/4755)

### tachyon-gamepad-input

- New package to manage callbacks on gamepad input
  [PR 4625](https://git.xarth.tv/emerging-platforms/tachyon/pull/4625)

### tachyon-more-ui

- removed `StylesAll`
  [PR 4858](https://git.xarth.tv/emerging-platforms/tachyon/pull/4858)

### tachyon-page-utils

- removed `mainManifestUrl` argument and output from Pulsar param generator
  utils. Provide a `src` prop directly to `PulsarCore` instead
  [PR 4828](https://git.xarth.tv/emerging-platforms/tachyon/pull/4828)

### tachyon-report-wizard

- Add toggle to show or hide close button on report wizard
  [PR 4909](https://git.xarth.tv/emerging-platforms/tachyon/pull/4909)
- Add new deadend pages for unreportable reasons/content types
  [PR 4749](https://git.xarth.tv/emerging-platforms/tachyon/pull/4749)

### tachyon-tv-nav

- Moves tv-nav to use intents from the User Intent package to simplify setting
  up listeners
  [PR 4925](https://git.xarth.tv/emerging-platforms/tachyon/pull/4925)

### tachyon-user-intent

- Adds `mapToIntents` to conveniently set up multiple listeners for an intent
  simultaneously
  [PR 4925](https://git.xarth.tv/emerging-platforms/tachyon/pull/4925)

### tachyon-utils-ts

- Fixes `Enum.keys` to support enums with matching key/value pairs
  [PR 4892](https://git.xarth.tv/emerging-platforms/tachyon/pull/4892)

## 31.0.0 (August 19, 2021)

### pulsar

- adds `useStreamAnalytics`, `useVodAnalytics`, and `useClipAnalytics` hooks for
  consuming fully populated Twitch player tracking events emitted from Pulsar
  players [PR 4788](https://git.xarth.tv/emerging-platforms/tachyon/pull/4788)

### pulsar-utils

- Add `manifestHasMinimumQualities` to probe manifest file for available
  resolutions and check if there exists at least one quality from a given array
  of qualities.
  [PR 4781](https://git.xarth.tv/emerging-platforms/tachyon/pull/4781)
- `createManifestUrl` utils can now set `lr` param through
  `adResolutionMatching` option
  [PR 4776](https://git.xarth.tv/emerging-platforms/tachyon/pull/4776)

### tachyon-auth

- Add `getTachyonUserCookieInBrowser`, `setTachyonUserCookieInBrowser` and
  `clearTachyonUserCookieInBrowser` for persisting user fields.
  [PR 4564](https://git.xarth.tv/emerging-platforms/tachyon/pull/4564)

### tachyon-auth-server

- Renames `clearAuthTokenOnServer` to `logoutOnServer` and updates functionality
  to also clear the user cookie.
  [PR 4564](https://git.xarth.tv/emerging-platforms/tachyon/pull/4564)

### tachyon-chat-ui

- Add `messages/` directory to published artifacts
  [PR 4784](https://git.xarth.tv/emerging-platforms/tachyon/pull/4784)

### tachyon-intl

- `TachyonIntlRoot` updated to accept and re-use an existing `TwitchIntl`
  instance, and previous props data are now grouped under the `data` key which
  accepts the new `IntlData` object (which replaces the previous `LocaleBundle`
  object) [PR 4777](https://git.xarth.tv/emerging-platforms/tachyon/pull/4777)

### tachyon-intl-server

- `selectLocaleBundle` renamed to `selectIntlData` `prepareLocaleDataCache`
  renamed to `prepareIntlDataCache`, and both updated to work with the new
  `IntlData` object from `tachyon-intl` (replacing the previous `LocaleBundle`
  object) [PR 4777](https://git.xarth.tv/emerging-platforms/tachyon/pull/4777)

### tachyon-more-ui

- Add `messages/` directory to published artifacts
  [PR 4784](https://git.xarth.tv/emerging-platforms/tachyon/pull/4784)
- Fix issue with viewbox sizing for `GlowConcernedMonitor` svg
  [PR 4774](https://git.xarth.tv/emerging-platforms/tachyon/pull/4774)

### tachyon-report-wizard

- Add `messages/` directory to published artifacts
  [PR 4784](https://git.xarth.tv/emerging-platforms/tachyon/pull/4784)
- Move `relay-build` to dev dependencies
  [PR 4789](https://git.xarth.tv/emerging-platforms/tachyon/pull/4789)

### tachyon-server-utils

- The `VersionPayload` argument has renamed version key from `v` to `version`.
  This impacts `getCookieComplexValueOnServer`,
  `getAndExtendCookieComplexValueOnServer` and `setCookieComplexValueOnServer`
  [PR 4564](https://git.xarth.tv/emerging-platforms/tachyon/pull/4564)

### tachyon-type-library

- Add `ForceExplicitGenericsObject` to standardize forced explicit generics
  [PR 4766](https://git.xarth.tv/emerging-platforms/tachyon/pull/4766)

### tachyon-utils-react

- Add missing `tachyon-utils-mem` dependency
  [PR 4779](https://git.xarth.tv/emerging-platforms/tachyon/pull/4779)

### tachyon-utils-twitch

- The `VersionPayload` argument has renamed version key from `v` to `version`.
  This impacts `getCookieComplexValue`, `getAndExtendCookieComplexValue` and
  `setCookieComplexValue`
  [PR 4564](https://git.xarth.tv/emerging-platforms/tachyon/pull/4564)

### twilight-date-picker

- Switch to Core UI's styled-components utilities
  [PR 4772](https://git.xarth.tv/emerging-platforms/tachyon/pull/4772)

## 30.0.0 (August 17, 2021)

### tachyon-chat-ui

- `twitch-core-ui` moved to peer dependency; `styled-components` and `polished`
  switched from wildcard to major version range on latest
  [PR 4756](https://git.xarth.tv/emerging-platforms/tachyon/pull/4756)

### tachyon-cypress

- `local-cypress` switched from wildcard to major version range
  [PR 4756](https://git.xarth.tv/emerging-platforms/tachyon/pull/4756)

### tachyon-cypress-reporters

- Add a new package to contain custom Twitch reporters
  [PR 4747](https://git.xarth.tv/emerging-platforms/tachyon/pull/4747)

### tachyon-more-ui

- `twitch-core-ui` moved to peer dependency; `styled-components` and `polished`
  switched from wildcard to major version range on latest
  [PR 4756](https://git.xarth.tv/emerging-platforms/tachyon/pull/4756)

### tachyon-relay

- `useMutationLegacy` removed
  [PR 4720](https://git.xarth.tv/emerging-platforms/tachyon/pull/4720)

### tachyon-report-wizard

- export mockReportWizardContext
  [PR 4736](https://git.xarth.tv/emerging-platforms/tachyon/pull/4736)
- `twitch-core-ui` moved to peer dependency
  [PR 4756](https://git.xarth.tv/emerging-platforms/tachyon/pull/4756)
- add additional enums for WizardLocation
  [PR 4751](https://git.xarth.tv/emerging-platforms/tachyon/pull/4751)

### tachyon-utils-stdlib

- Improved types of `defaultsDeep` to help eliminate need for casting;
  `isPlainObject` now takes arg of type `unknown` instead of `{}`
  [PR 4759](https://git.xarth.tv/emerging-platforms/tachyon/pull/4759)

### twilight-date-picker

- `twitch-core-ui` moved to peer dependency
  [PR 4756](https://git.xarth.tv/emerging-platforms/tachyon/pull/4756)

### tachyon-server-utils

- Added `getCookieComplexValueOnServer`,
  `getAndExtendCookieComplexValueOnServer` and `setCookieComplexValueOnServer`
  for encoding / decoding objects as cookie values
  [PR 4746](https://git.xarth.tv/emerging-platforms/tachyon/pull/4746)
- Removed providing encode / decode overrides for cookie getters and setters,
  respectively.
  [PR 4746](https://git.xarth.tv/emerging-platforms/tachyon/pull/4746)

### tachyon-utils-twitch

- Added `getCookieComplexValue`, `getAndExtendCookieComplexValue` and
  `setCookieComplexValue` for encoding / decoding objects as cookie values
  [PR 4746](https://git.xarth.tv/emerging-platforms/tachyon/pull/4746)
- Removed providing encode / decode overrides for cookie getters and setters,
  respectively.
  [PR 4746](https://git.xarth.tv/emerging-platforms/tachyon/pull/4746)

## 29.1.1 (August 12, 2021)

### tachyon-report-wizard

- `twitch-core-ui` dependency changed to >22.0.0 since Core UI isn't fully
  semver [PR 4738](https://git.xarth.tv/emerging-platforms/tachyon/pull/4738)

## 29.1.0 (August 11, 2021)

### eslint-plugin-tachyon

- `tachyon/no-aliased-absolute-imports` added
  [PR 4704](https://git.xarth.tv/emerging-platforms/tachyon/pull/4704)

### pulsar-analytics

- Add `buffer-empty`, `buffer-refill`, and `video_end` events
  [PR 4685](https://git.xarth.tv/emerging-platforms/tachyon/pull/4685)
- Add `video_error` event
  [PR 4722](https://git.xarth.tv/emerging-platforms/tachyon/pull/4722)

### pulsar-native

- `poster` prop added as an optional way to specify a poster image for the video
  element [PR 4723](https://git.xarth.tv/emerging-platforms/tachyon/pull/4723)

### pulsar-player-core

- `poster` prop added as an optional way to specify a poster image for the video
  element [PR 4723](https://git.xarth.tv/emerging-platforms/tachyon/pull/4723)

### pulsar-shaka

- `poster` prop added as an optional way to specify a poster image for the video
  element [PR 4723](https://git.xarth.tv/emerging-platforms/tachyon/pull/4723)

### tachyon-auth

- `getCurrentUser` now extends the login cookie on each access
  [PR 4686](https://git.xarth.tv/emerging-platforms/tachyon/pull/4686)

### tachyon-auth-server

- `getCurrentUserOnServer` now extends the login cookie on each access
  [PR 4686](https://git.xarth.tv/emerging-platforms/tachyon/pull/4686)

### tachyon-more-ui

- Initial release of More UI, which includes Glow SVGs, responsive image
  helpers, QR Code tools, styled-components mixins, and more
  [PR 4700](https://git.xarth.tv/emerging-platforms/tachyon/pull/4700)

### tachyon-page-utils

- Consolidated all tachyon cookies into export from package:
  `tachyon-captions-enabled`, `tachyon-accepted-cookie-notice`,
  `tachyon-mature`, and `tachyon-prefers-color-scheme`
  [PR 4686](https://git.xarth.tv/emerging-platforms/tachyon/pull/4686)

### tachyon-report-wizard

- `targetUserUsername` is now optional with fallback behavior in
  `<ReportWizardRoot />`
  [PR 4692](https://git.xarth.tv/emerging-platforms/tachyon/pull/4692)
- Username, Creator Goal, and Off Platform report types are now supported
  [PR 4699](https://git.xarth.tv/emerging-platforms/tachyon/pull/4699)
- ReportContentType now accepts a string to avoid blocking twilight before
  schema gets updated in this package, will default to type: "USER_REPORT"
  [PR 4701](https://git.xarth.tv/emerging-platforms/tachyon/pull/4701)
- onEvent now passes event name and fields for various wizard events
  [PR 4703](https://git.xarth.tv/emerging-platforms/tachyon/pull/4703)
- added targetUserBlocked prop to ReportWizardRoot to enable block checkbox to
  be controlled from client
  [PR 4725](https://git.xarth.tv/emerging-platforms/tachyon/pull/4725)

### tachyon-utils-server

- Added `getAndExtendCookieValueOnServer` which should be preferred over the
  `getCookieValueOnServer`. The new utility extends the cookies `maxAge` on each
  access, and accepts `migrationNames` which can be used to migrate cookie
  names, such as adding a namespace prefix. The old cookie name will be replaced
  upon extension.
- `setCookieValueOnServer` now defaults to setting a `maxAge` of 13 months.
- `getDeviceIDOnServer` now extends the deviceId cookie on each access.
  [PR 4686](https://git.xarth.tv/emerging-platforms/tachyon/pull/4686)

### tachyon-utils-twitch

- Added `getAndExtendCookieValue` which should be preferred over the
  `getCookieValue`. The new utility extends the cookies `maxAge` on each access,
  and accepts `migrationNames` which can be used to migrate cookie names, such
  as adding a namespace prefix. The old cookie name will be replaced upon
  extension.
- `setCookieValue` now defaults to setting a `maxAge` of 13 months.
  [PR 4686](https://git.xarth.tv/emerging-platforms/tachyon/pull/4686)

## 29.0.0 (August 3, 20201)

### eslint-plugin-tachyon

- `tachyon/no-use-immutable-callback` removed following deprecation period
  [PR 4645](https://git.xarth.tv/emerging-platforms/tachyon/pull/4645)
- `tachyon/prefer-use-const` rule added to encourage `useConst` usage
  [PR 4658](https://git.xarth.tv/emerging-platforms/tachyon/pull/4658)

### pulsar-player-controller

- Removed `metadata` event and replaced with `sourceStreamCue` in
  `subscribeEventListener` API
  [PR 4595](https://git.xarth.tv/emerging-platforms/tachyon/pull/4595)

### pulsar-player-core

- Upgraded Player-Core to `1.4.0-twitch.7-rc.1`
  [PR 4595](https://git.xarth.tv/emerging-platforms/tachyon/pull/4595)

### tachyon-cypress

- Add a new package, including the `getSc` and `findSc`
  [PR 4660](https://git.xarth.tv/emerging-platforms/tachyon/pull/4660)

### tachyon-report-wizard

- New package created for the report wizard. Includes context for wizard logic
  and UI components.
  [PR 4656](https://git.xarth.tv/emerging-platforms/tachyon/pull/4656)
- Add support for searching detailed reasons in reason search and filling reason
  and detailed reason on selection
  [PR 4664](https://git.xarth.tv/emerging-platforms/tachyon/pull/4664)

### tachyon-user-intent

- New package to manage callbacks on user input for apps with multiple input
  methods needing unified eventing
  [PR 4588](https://git.xarth.tv/emerging-platforms/tachyon/pull/4588)

### tachyon-utils-react

- `useImmutableCallback` removed following deprecation period
  [PR 4645](https://git.xarth.tv/emerging-platforms/tachyon/pull/4645)

### tachyon-utils-stdlib

- Adds `isValidEmail` to validate if a string is a valid email address
  [PR 4644](https://git.xarth.tv/emerging-platforms/tachyon/pull/4644)

## 28.0.0 (July 21, 2021)

### eslint-plugin-tachyon

- Adds `tachyon/no-rollup-package-import` and `tachyon/no-sub-package-import`
  for managing import behavior from rollup convenience packages and update docs
  [PR 4613](https://git.xarth.tv/emerging-platforms/tachyon/pull/4613)
- Adds `tachyon/no-use-immutable-callback` to auto-fix replacing deprecated
  `useImmutableCallback` with `useConstCallback`
  [PR 4609](https://git.xarth.tv/emerging-platforms/tachyon/pull/4609)
- Adds `tachyon/no-disable-rules` for managing disabling rules
  [PR 4618](https://git.xarth.tv/emerging-platforms/tachyon/pull/4618)

### pulsar

- Added as a convenient way to consume Pulsar imports under a single re-export
  only package to avoid import name thrashing
  [PR 4580](https://git.xarth.tv/emerging-platforms/tachyon/pull/4580)

### pulsar-analytics

- New package created by rename of `tachyon-pulsar-analytics`
  [PR 4580](https://git.xarth.tv/emerging-platforms/tachyon/pull/4580)

### pulsar-native

- New package created as a result of extracting `PulsarNative` from
  `tachyon-pulsar-core` containing only a Pulsar API for consuming Native
  Browser HLS/MP4 playback.
  [PR 4580](https://git.xarth.tv/emerging-platforms/tachyon/pull/4580)

### pulsar-player-controller

- The `PlayerController` React API was extracted from `tachyon-pulsar-core` into
  this new stand alone package
  [PR 4580](https://git.xarth.tv/emerging-platforms/tachyon/pull/4580)

### pulsar-player-core

- New package, renamed version of `tachyon-pulsar-core`
  [PR 4614](https://git.xarth.tv/emerging-platforms/tachyon/pull/4614) without
  `PulsarNative` or manifest URL helpers which now live in the `pulsar-utils`
  package

### pulsar-shaka

- Added new `pulsar-shaka` package that provides a Pulsar API for Shaka-Player
  based HLS playback
  [PR 4530](https://git.xarth.tv/emerging-platforms/tachyon/pull/4530)

### pulsar-utils

- New package housing manifest URL, player type, and other Pulsar utilities used
  by all player backends
  [PR 4614](https://git.xarth.tv/emerging-platforms/tachyon/pull/4614)

### tachyon-auth

- `CurrentUserRoot` now automatically detects logged in status client side.
  Serverside state can still be seeded via the `loggedIn` prop.
  [PR 4575](https://git.xarth.tv/emerging-platforms/tachyon/pull/4575)
- Rename `CurrentUserRoot`'s `isLoggedIn` prop to `isLoggedInServerside`
  [PR 4575](https://git.xarth.tv/emerging-platforms/tachyon/pull/4575)

### tachyon-page-utils

- Simplifies `useStartTimeFromRouter` hook to return the VOD timestamp instead
  of a thunk / getter function.
  [PR 4616](https://git.xarth.tv/emerging-platforms/tachyon/pull/4616)

### tachyon-more-ui

- Add gear-shaped glow svg for Moonbase auth page
  [PR 4607](https://git.xarth.tv/emerging-platforms/tachyon/pull/4607)

### tachyon-pulsar-analytics

- Package renamed to `pulsar-analytics`
  [PR 4580](https://git.xarth.tv/emerging-platforms/tachyon/pull/4580)

### tachyon-pulsar-core

- `usePlaybackAutoplayStatus` now clears the `unmuted-blocked` status when a
  volume event is emitted and the player is no longer muted. Also clears the
  `autoplay-blocked` status when a playing event is emitted and the player is no
  longer paused
  [PR 4542](https://git.xarth.tv/emerging-platforms/tachyon/pull/4542)
- `PlayerController` API exports removed from package, consume via
  `pulsar-player-controller`
  [PR 4580](https://git.xarth.tv/emerging-platforms/tachyon/pull/4580)
- `PulsarCore` now attempts to reuse a player worker
  [PR 4629](https://git.xarth.tv/emerging-platforms/tachyon/pull/4629)
- Renamed to `pulsar-player-core`
  [PR 4614](https://git.xarth.tv/emerging-platforms/tachyon/pull/4614)

### tachyon-relay

- Unauthorized retries now ignore any authorization options. Previously, clients
  needed to mutate the options passed to getFetchQuery or provide a dynamic
  getter for the authorization token. That was easy to get wrong, and easy to
  forget to test, so this removes some flexibility to create a better pit of
  success. [PR 4594](https://git.xarth.tv/emerging-platforms/tachyon/pull/4594)

### tachyon-test-utils

- Updates `mockChangeEvent` and `mockKeyDown` to accept deep partial arguments
  [PR 4612](https://git.xarth.tv/emerging-platforms/tachyon/pull/4612)

### tachyon-utils-crypto

- Exports `spadeifyEvents` and `unspadeifyEvents` for working with Spade
  reporting and `stringToSha256` for hashing
  [PR 4591](https://git.xarth.tv/emerging-platforms/tachyon/pull/4591)

### tachyon-utils-react

- Adds `useConst`, `useConstCallback`, `useLatest`, and `useMethods` hooks. (see
  [Usage Notes](https://git.xarth.tv/emerging-platforms/tachyon/tree/main/packages/tachyon-core/utils-react#useage-notes)
  for more info)
  [PR 4609](https://git.xarth.tv/emerging-platforms/tachyon/pull/4609)
- Deprecates `useImmutableCallback` in favor of `useConstCallback` (adds
  auto-fix lint rule)
  [PR 4609](https://git.xarth.tv/emerging-platforms/tachyon/pull/4609)

## 27.0.0 (June 23, 2021)

### general

- Updated to use Typescript 4.3
  [PR 4497](https://git.xarth.tv/emerging-platforms/tachyon/pull/4497)
- All packages now import from specific `tachyon-utils-*` instead of the
  `tachyon-utils` rollup to ease transitive dependency management
  [PR 4513](https://git.xarth.tv/emerging-platforms/tachyon/pull/4513)

### eslint-plugin-tachyon

- Adds `no-mock-clear` lint rule for clarity during unit testing
  [PR 4505](https://git.xarth.tv/emerging-platforms/tachyon/pull/4505)

### tachyon-environment

- Add `isAmazonEchoShowDevice` helper to determine if user is using an Amazon
  Echo Show Device
  [PR4550](https://git.xarth.tv/emerging-platforms/tachyon/pull/4550)

### tachyon-event-tracker

- Add netinfo information to event-tracker
  [PR 4528](https://git.xarth.tv/emerging-platforms/tachyon/pull/4528)

### tachyon-latency-tracker

- Removed netinfo from latency-tracker
  [PR 4528](https://git.xarth.tv/emerging-platforms/tachyon/pull/4528)

### tachyon-more-ui

- Add glow svgs for Not Interested and Entity Information pages
  [PR 4386](https://git.xarth.tv/emerging-platforms/tachyon/pull/4386)
- Add `strongText` util function for bolding text, commonly used for `x:strong`
  in `formatMessage`
  [PR4545](https://git.xarth.tv/emerging-platforms/tachyon/pull/4545)
- Updated IOSShareIcon and IOSAddToHomescreenIcon to work with themes via
  `fill="currentColor"`
  [PR 4512](https://git.xarth.tv/emerging-platforms/tachyon/pull/4512)
- adds ClientSideErrorBoundary
  [PR 4547](https://git.xarth.tv/emerging-platforms/tachyon/pull/4547)

### tachyon-pulsar-analytics

- Added package to implement Twitch's Video Playback analytics (video-play)
  [PR 4503](https://git.xarth.tv/emerging-platforms/tachyon/pull/4503)
- Adding `minute-watched` event tracking
  [PR 4523](https://git.xarth.tv/emerging-platforms/tachyon/pull/4523)

### tachyon-pulsar-core

- Deprecated a number of PulsarCore param callbacks that should be replaced with
  PlayerController hook APIs
  [PR 4555](https://git.xarth.tv/emerging-platforms/tachyon/pull/4555)

### tachyon-relay

- `initEnvironment` exposes new optional `fetchQueryOpts` params `gqlHeaders`
  (for adding arbitrary headers to gql requests) an `onEvent` (for tracking
  events emitted during data fetching)
  [PR 4467](https://git.xarth.tv/emerging-platforms/tachyon/pull/4467)

### tachyon-utils-crypto

- extracted the following from `tachyon-utils`: `getRandomValue`
  [PR 4513](https://git.xarth.tv/emerging-platforms/tachyon/pull/4513)

### tachyon-utils-hooks

- renamed to `tachyon-utils-react`
  [PR 4513](https://git.xarth.tv/emerging-platforms/tachyon/pull/4513)

### tachyon-utils-react

- extracted the following from `tachyon-utils`: `contextTypeValidator`,
  `getComponentName`, and ImpressionListener-related functionality
  [PR 4513](https://git.xarth.tv/emerging-platforms/tachyon/pull/4513)

### tachyon-utils-stdlib

- extracted the following from `tachyon-utils`: `buildCacheHeader`,
  `errorMessageFromCatch`, `fetchData`, `flattenHeaderOrParam`, `isBrowser`,
  `isOffline`, and `PausableInterval`
  [PR 4513](https://git.xarth.tv/emerging-platforms/tachyon/pull/4513)
- Converting `PausableInterval` to `createPausableInterval` and adjusting input
  arguments [PR 4523](https://git.xarth.tv/emerging-platforms/tachyon/pull/4523)

### tachyon-utils-twitch

- extracted the following from `tachyon-utils`: cookie-related functions,
  `getCurrentTwitchDomain`, `getFormattedUserDisplayName`, `getGameDisplayName`,
  `formatVideoLength`, `reduceToNonNullNodes`, `safeLogin`, and
  unique-id-related functions
  [PR 4513](https://git.xarth.tv/emerging-platforms/tachyon/pull/4513)

### twitch-chat-client

- Adds additional `goalData` fields to existing subscription TMI messages,
  including the following `msgIDs`: `sub, resub, extendsub, primepaidupgrade`
  `(anon)subgift, (anon)submysterygift, (anon)giftpaidupgrade`
  [PR 4494](https://git.xarth.tv/emerging-platforms/tachyon/pull/4494)
- Adds `giftTheme` to `subgift` and `submysterygift` messages
  [PR 4537](https://git.xarth.tv/emerging-platforms/tachyon/pull/4537)
- Adds additional `funFact` field to existing subscription TMI message only when
  `msgID` is `resub`
  [PR 4927](https://git.xarth.tv/emerging-platforms/tachyon/pull/4927)

## 26.0.0 (May 24, 2021)

### general

- Updated to use Core UI v22.0.0
  [PR 4406](https://git.xarth.tv/emerging-platforms/tachyon/pull/4406)
- `@babel/runtime` package dependencies updated to track latest minor (7.14.0)
  [PR 4426](https://git.xarth.tv/emerging-platforms/tachyon/pull/4426)

### tachyon-auth

- Adds an optional argument to skip the `onLogin` callback when `login` is
  called. Also eliminates the unnecessary fields for the `OAuthToken` type.
  [PR 4390](https://git.xarth.tv/emerging-platforms/tachyon/pull/4390)

### tachyon-more-ui

- Adds `Fonts` and `ScFonts` components for loading Core UI fonts; `StyleRoot`
  and `ScStyleRoot` renamed to `TvStyles` and `ScTvStyles`, respectively
  [PR 4406](https://git.xarth.tv/emerging-platforms/tachyon/pull/4406)

- Adds glow svgs for privacy page and preview player error overlays.
  [PR 4437](https://git.xarth.tv/emerging-platforms/tachyon/pull/4437)

### tachyon-package-builder

- Fixed spawn bug with windows
  [PR 4410](https://git.xarth.tv/emerging-platforms/tachyon/pull/4410)

### twilight-date-picker

- Packaged version of twilight's date-picker component (based on pikaday)
  [PR 4194](https://git.xarth.tv/emerging-platforms/tachyon/pull/4194)

## 25.1.2 (May 12, 2021)

### tachyon-utils

- Adds `null` as an argument value for flattenHeaderOrParam to work more easily
  with `query-string`
  [PR 4398](https://git.xarth.tv/emerging-platforms/tachyon/pull/4398)

### twitch-chat-client

- Adds support for crowd-chant-parent-msg-id outbound metadata
  [PR 4334](https://git.xarth.tv/emerging-platforms/tachyon/pull/4334)

## 25.1.1 (May 4, 2021)

### tachyon-chat

- Add `bitsImageUrl` to parsed Chat message objects
  [PR 4360](https://git.xarth.tv/emerging-platforms/tachyon/pull/4360)

### tachyon-environment

- Add `usePublicPlatformName` as a way to get a platform string that can be
  presented to users in thing's like customer support tickets
  [PR 4285](https://git.xarth.tv/emerging-platforms/tachyon/pull/4285)

### tachyon-more-ui

- Add glow svgs for Help, ToS, Report Channel, & Join the Conversation pages
  [PR 4289](https://git.xarth.tv/emerging-platforms/tachyon/pull/4289)
- Added `IOSAddToHomescreenIcon` and `IOSShareIcon` SVGs
  [PR 4191](https://git.xarth.tv/emerging-platforms/tachyon/pull/4191)

### tachyon-notification

- Adds `createMockNotificationContext` test helper for use with our
  `tachyon-test-utils` context mount helper system
  [PR 4310](https://git.xarth.tv/emerging-platforms/tachyon/pull/4310)

### tachyon-page-utils

- Adds support for Stream and VOD playback from provided main manifest URL in
  param mapper functions
  [PR 4298](https://git.xarth.tv/emerging-platforms/tachyon/pull/4298)

### tachyon-pulsar-core

- Adds support for Stream and VOD playback from provided main manifest URL
  [PR 4298](https://git.xarth.tv/emerging-platforms/tachyon/pull/4298)
- Adds usePlaybackAutoplayStatus hook
  [PR 4304](https://git.xarth.tv/emerging-platforms/tachyon/pull/4304)
- Updated Player-Core to `1.4.0-twitch.1-rc.1`
  [PR 4357](https://git.xarth.tv/emerging-platforms/tachyon/pull/4357)

### tachyon-relay

- Adds the `useRefetchableFragmentWithoutSuspense` hook for bridging until React
  Concurrent mode
  [PR 4338](https://git.xarth.tv/emerging-platforms/tachyon/pull/4338)

### tachyon-utils-stdlib

- Now exports the TVCodes enum
  [PR 4281](https://git.xarth.tv/emerging-platforms/tachyon/pull/4281)

## 25.1.0 (April 14, 2021)

### general

- Dependencies updated, including moving to Relay 11
  [PR 4273](https://git.xarth.tv/emerging-platforms/tachyon/pull/4273)

### eslint-plugin-tachyon

- Adds `no-bare-react-relay-import` lint rule to help with forward migration
  [PR 4280](https://git.xarth.tv/emerging-platforms/tachyon/pull/4280)

### tachyon-relay

- Updated to work with Relay 11: exports `<DangerousServerSuspense>` component,
  renames `useMutation` to `useMutationLegacy` as Relay provides this hook
  itself, adds docs showing new preferred pattern
  [PR 4280](https://git.xarth.tv/emerging-platforms/tachyon/pull/4280)

### twitch-chat-client

- add missing type to cheer events
  [PR 4276](https://git.xarth.tv/emerging-platforms/tachyon/pull/4276)

## 25.0.1 (April 12, 2021)

### twitch-chat-client

- Add missing root-level exports
  [PR 4270](https://git.xarth.tv/emerging-platforms/tachyon/pull/4270)

## 25.0.0 (April 9, 2021)

### general

- Most dependencies updated, including moving to React 17 and TS 4.2
  [PR 4113](https://git.xarth.tv/emerging-platforms/tachyon/pull/4113)

### eslint-plugin-tachyon

- Adds `no-single-child-directional-navs` rule for converting to NodeNav
  [PR 4085](https://git.xarth.tv/emerging-platforms/tachyon/pull/4085)

### tachyon-metadata

- First implementation of the tachyon-metadata package
  [PR 4124](https://git.xarth.tv/emerging-platforms/tachyon/pull/4124)

### tachyon-discovery

- Remove algolia from types and tracking events. Remove search UI components
  [PR 4090](https://git.xarth.tv/emerging-platforms/tachyon/pull/4090)
- Add `RelatedChannels` search category to search tracking
  [PR 4120](https://git.xarth.tv/emerging-platforms/tachyon/pull/4120)
- Add channel page `onChannelPageItemClick` and `onChannelPageItemDisplay`
  tracking events to `DiscoveryTrackingRoot`
  [PR 4228](https://git.xarth.tv/emerging-platforms/tachyon/pull/4228)

### tachyon-event-tracker

- Exports `usePageview` for special-case usages
  [PR 4153](https://git.xarth.tv/emerging-platforms/tachyon/pull/4153)
- Changed `onEvent` in `EventTrackerRoot` to default to a noop to prevent
  unnecessary logging
  [PR 4514](https://git.xarth.tv/emerging-platforms/tachyon/pull/4514)

### tachyon-more-ui

- `safeAreaWidthInVw` and `safeAreaPaddingInVw` replace older methods, now take
  `vw` argument and create both standard and safe-area-aware values; added
  `horizontalOverflowIntoSafeArea`
  [PR 4111](https://git.xarth.tv/emerging-platforms/tachyon/pull/4111)
- Added `generateFontHtml` for working with `twitch-core-ui-fonts` `fonts.json`
  [PR 4115](https://git.xarth.tv/emerging-platforms/tachyon/pull/4115)
- Added `safeAreaBottomPaddingToRemoveInsets`
  [PR 4127](https://git.xarth.tv/emerging-platforms/tachyon/pull/4127)
- In coordination with the changes to `tachyon-latency-tracker`, all
  `LatencyTracked*` components and `QueryRendererLatencyManager` have been
  removed, and `ClientOnly` no longer exposes the `hasCriticalChildren` prop and
  renames `onSSR` prop to `ssrPlaceholder`.
  [PR 4152](https://git.xarth.tv/emerging-platforms/tachyon/pull/4152)
- Add `formatTimeRange` helper
  [PR 4182](https://git.xarth.tv/emerging-platforms/tachyon/pull/4182)

### tachyon-latency-tracker

- Add PerformancePolyfill
  [PR 4122](https://git.xarth.tv/emerging-platforms/tachyon/pull/4122)
- Refactored to support new SSR-based approach. `withLatencyTracker` (and all
  component-level tracking) has been removed and replaced with the new
  `<LatencyTransitionComplete />` component and `useLatencyTransitionComplete()`
  hook. Abandonment tracking has also been removed. Accordingly,
  `LatencyTrackerRoot` has dropped the `componentReportingThreshold` and
  `reportTransitionAbandonment` props.
  [PR 4152](https://git.xarth.tv/emerging-platforms/tachyon/pull/4152)
- Adds `disableLatencyTracking` prop to `LatencyTrackerRoot` and `location`
  parameter to transition complete tracking for special-case overrides
  [PR 4153](https://git.xarth.tv/emerging-platforms/tachyon/pull/4153)

### tachyon-page-utils

- Adds generic argument for `ChannelInitialProps`
  [PR 3861](https://git.xarth.tv/emerging-platforms/tachyon/pull/3861)
- Adds `useStartTimeFromRouter` hook for getting a VOD timestamp from URL params
  [PR 4132](https://git.xarth.tv/emerging-platforms/tachyon/pull/4132)
- Adds new pageview tracking event functions for the watch, home, schedule, vod,
  and clips pages.
  [PR 4190](https://git.xarth.tv/emerging-platforms/tachyon/pull/4190)
- Adds utils for the channel vods page.
  [PR 4236](https://git.xarth.tv/emerging-platforms/tachyon/pull/4236)

### tachyon-pulsar-core

- Adds `mockClosedCaptionsContext` convenience function for use with test-utils
  `wrappingContexts` system.
  [PR 4084](https://git.xarth.tv/emerging-platforms/tachyon/pull/4084)
- Adds `usePlaybackAd` for building SureStream ad experiences
  [PR 4129](https://git.xarth.tv/emerging-platforms/tachyon/pull/4129)
- Adds `usePlaybackQuality` to enable quality switching features
  [PR 4131](https://git.xarth.tv/emerging-platforms/tachyon/pull/4131)
- Upgrade to Player-Core `1.3.0-twitch.web.1`
  [PR 4202](https://git.xarth.tv/emerging-platforms/tachyon/pull/4202)
- Adds `onSeekCompleted` callback
  [PR 4204](https://git.xarth.tv/emerging-platforms/tachyon/pull/4204)
- Adds `liveLowLatencyEnabled` option to disable (defaults to enabled)
  [PR 4220](https://git.xarth.tv/emerging-platforms/tachyon/pull/4220)

### tachyon-relay

- Add `useRefetchList` to generalize pattern for infinite lists
  [PR 4108](https://git.xarth.tv/emerging-platforms/tachyon/pull/4108)
- Update `useMutation` to return a function that can take variable overrides at
  call-time [PR 4239](https://git.xarth.tv/emerging-platforms/tachyon/pull/4239)

### tachyon-relay-build

- Switch to using GQL sandbox for introspection query and output JSON instead of
  SDL [PR 4259](https://git.xarth.tv/emerging-platforms/tachyon/pull/4259)

### tachyon-tv-nav

- Adds `NodeNav` for nav area usages with a single focusable child
  [PR 4085](https://git.xarth.tv/emerging-platforms/tachyon/pull/4085)
- Adds `onDown`, `onLeft`, `onRight`, and `onUp` to all nav areas to precede
  and/or preclude the normal nav behaviors.
  [PR 4083](https://git.xarth.tv/emerging-platforms/tachyon/pull/4083)

### tachyon-test-utils

- `defaultsDeep` and `isPlainObject` extracted into `tachyon-utils-stdlib`
  [PR 4237](https://git.xarth.tv/emerging-platforms/tachyon/pull/4237)

### tachyon-type-library

- Remove `OmitGqlOtherType`
  [PR 4081](https://git.xarth.tv/emerging-platforms/tachyon/pull/4081)
- Remove `type-fest` re-exports; instead import utilities from `type-fest`
  directly [PR 4209](https://git.xarth.tv/emerging-platforms/tachyon/pull/4209)

### tachyon-utils-hooks

- Add `useJSEnabled` a progressive enhancement for when JS is enabled and
  booted. Used for UI elements that can't do anything until JS boots
  [PR 4102](https://git.xarth.tv/emerging-platforms/tachyon/pull/4102)

### tachyon-utils-stdlib

- Add `htmlescape` helper
  [PR 4124](https://git.xarth.tv/emerging-platforms/tachyon/pull/4124)
- Add `partition` helper
  [PR 4193](https://git.xarth.tv/emerging-platforms/tachyon/pull/4193)
- Add `groupBy` helper
  [PR 4208](https://git.xarth.tv/emerging-platforms/tachyon/pull/4208)
- Add `defaultsDeep` and `isPlainObject` (moved from `tacyhon-test-utils`)
  [PR 4237](https://git.xarth.tv/emerging-platforms/tachyon/pull/4237)
- Adds tv remote button support to `legacyKeyboardEventHandler` for 2017 LG TVs
  [PR 4232](https://git.xarth.tv/emerging-platforms/tachyon/pull/4232)

### tachyon-utils-ts

- Adds `'%future added value'` and `'%other'` to `exhaustedCase`
  [PR 4081](https://git.xarth.tv/emerging-platforms/tachyon/pull/4081)

### twitch-chat-client

- Migrated into Tachyon
  [PR 4201](https://git.xarth.tv/emerging-platforms/tachyon/pull/4201)

## 24.0.0 (February 24, 2021)

### eslint-plugin-tachyon

- `bowser-parser-fallback` rule added to prevent Bowser from throwing in odd
  environments
  [PR 4029](https://git.xarth.tv/emerging-platforms/tachyon/pull/4029)

### tachyon-event-reporter

- export `SPADE_ROTATOR_URI` as convenience for consumers
  [PR 4047](https://git.xarth.tv/emerging-platforms/tachyon/pull/4047)

### tachyon-environment

- experimental `createMockStaticEnvironmentContext` is provided for
  compatibility with `contextMocks` in `tachyon-test-utils`
  [PR 4018](https://git.xarth.tv/emerging-platforms/tachyon/pull/4018)
- Updated getOtherEnvMock to accept an optional object allowing both a UserAgent
  and Platform to be specified for greater flexibility
  [PR 4049](https://git.xarth.tv/emerging-platforms/tachyon/pull/4049)

### tachyon-more-ui

- Removes "inverted" option from QR code and adjusts coloring to use light
  background / black foreground for better scannability
  [PR 4037](https://git.xarth.tv/emerging-platforms/tachyon/pull/4037)
- `getBoxArtSrcAndSrcSet`, `getBoxArtSrc`, `getChannelThumbnailSrcAndSrcSet`,
  `getChannelThumbnailSrc` now fallback by default. To opt out, call site can
  pass an explicit `{ fallback: false }` option.
  [PR 4038](https://git.xarth.tv/emerging-platforms/tachyon/pull/4038)
- added `safeAreaHorizontalPaddingToRemoveInsets` styled-components mixin
  [PR 4061](https://git.xarth.tv/emerging-platforms/tachyon/pull/4061)

### tachyon-page-utils

- Adds `useVodRestrictions` hook.
  [PR 4016](https://git.xarth.tv/emerging-platforms/tachyon/pull/4016)
- Adds `useChannelRestrictions` hook, removes `useRestrictions`. Adds
  `handlePlayeError` support to both restriction hooks. Adds
  `PLAYER_ERROR_RESTRICTION_MAPPINGS` to provide easy player error mocking to
  test restrictions.
  [PR 4034](https://git.xarth.tv/emerging-platforms/tachyon/pull/4034)
- Adds `useClipRestrictions` hook.
  [PR 4072](https://git.xarth.tv/emerging-platforms/tachyon/pull/4072)

### tachyon-pulsar-core

- Adds `useErrorListener` which exposes raw PlayerError emitted from Player-Core
  for more granular error handling
  [PR 4034](https://git.xarth.tv/emerging-platforms/tachyon/pull/4034)

### tachyon-relay

- Splits schema update command into new package `tachyon-relay-build`;
  `FCWithQuery` now accepts QueryVariables type too
  [PR 4074](https://git.xarth.tv/emerging-platforms/tachyon/pull/4074)

### tachyon-relay-build

- New package containing `update-gql-schema` command and other conveniences for
  consumers outside the monorepo; command now pulls from `twitch-relay` config
  [PR 4074](https://git.xarth.tv/emerging-platforms/tachyon/pull/4074)

### tachyon-test-utils

- `createMountWrapperFactory` now works with `contextMocks` to provide context
  to components without resorting to jest mocking
  [PR 4018](https://git.xarth.tv/emerging-platforms/tachyon/pull/4018)
- `contextMocks` parameter renamed to `wrappingContexts`
  [PR 4030](https://git.xarth.tv/emerging-platforms/tachyon/pull/4030)
- The factory function returned from `createMountWrapperFactory` now exposes a
  `updateWrappingContext` function in its return payload (alongside `contexts`)
  [PR 4058](https://git.xarth.tv/emerging-platforms/tachyon/pull/4058)

### tachyon-utils

- `clearCookieValue` has been updated to always attempt to delete both the base
  version and `_samesite_compat` version of cookies.
  [PR 4019](https://git.xarth.tv/emerging-platforms/tachyon/pull/4019)
- `BOWSER_USER_AGENT_FALLBACK` exported for safer usage of Bowser
  [PR 4029](https://git.xarth.tv/emerging-platforms/tachyon/pull/4029)

### tachyon-utils-stdlib

- `identity` moved to this package but still reexported by `tachyon-utils`
  [PR 4066](https://git.xarth.tv/emerging-platforms/tachyon/pull/4066)
- Added `uniq`
  [PR 4078](https://git.xarth.tv/emerging-platforms/tachyon/pull/4078)

## 23.0.0 (February 11, 2021)

### general

- Most dependencies updated, including moving to TypeScript 4.1 and Next 10
  [PR 3946](https://git.xarth.tv/emerging-platforms/tachyon/pull/3946)
- Dependencies updated to rely on Core UI 19
  [PR 3964](https://git.xarth.tv/emerging-platforms/tachyon/pull/3964)

### eslint-plugin-tachyon

- `no-styled-layout` rule moved to `eslint-plugin-twitch-core-ui`
  [PR 3964](https://git.xarth.tv/emerging-platforms/tachyon/pull/3964)
- Renamed the `all` config to `recommended`. Also added a new config specific to
  starshot called `starshot`. If you are using these rules you should update
  from `plugin:tachyon/all` to `plugin:tachyon/recommended` in your eslint
  config extensions.
  [PR 3910](https://git.xarth.tv/emerging-platforms/tachyon/pull/3910)

### tachyon-auth

- The login QR code now includes a `device-metadata` parameter that is sent back
  on a successful validation. This parameter is then used to track the use of
  the QR code.
  [PR 3772](https://git.xarth.tv/emerging-platforms/tachyon/pull/3772)
- Added `onLoggedIn()` and `onLoggedOut()` callbacks to `CurrentUserRoot`. This
  allows the application to perform any custom work in response to these user
  changes. [PR 3910](https://git.xarth.tv/emerging-platforms/tachyon/pull/3910)
- Renamed `CurrentUserRoot` props to `isLoggedIn` to `loggedIn`, `onLoggedIn` to
  `onLogin`, and `onLoggedOut` to `onLogout`.
  [PR 3981](https://git.xarth.tv/emerging-platforms/tachyon/pull/3981)

### tachyon-debug-reporter

- Emitted events are now flattened to be event-tracker-compatible
  [PR 3870](https://git.xarth.tv/emerging-platforms/tachyon/pull/3870)

### tachyon-discovery

- Emitted events are now flattened to be event-tracker-compatible
  [PR 3870](https://git.xarth.tv/emerging-platforms/tachyon/pull/3870)
- Added `model_tracking_id` to playerTracking events, added option to set
  `item_tracking_id` and `model_tracking_id` defaults through props to
  `DiscoveryTrackingRoot`.
  [PR 3968](https://git.xarth.tv/emerging-platforms/tachyon/pull/3968)

### tachyon-dynamic-settings

- move `fetchDynamicSettings` to `tachyon-dynamic-settings` and removes server
  side dependency. Now asynchronous.
  [PR 3959](https://git.xarth.tv/emerging-platforms/tachyon/pull/3959)
- Dynamic settings now supports generics for pre- and post-processing of app-
  specific settings
  [PR 4014](https://git.xarth.tv/emerging-platforms/tachyon/pull/4014)
- processor function now types all raw values as `unknown` to enforce full type
  verification (see matching typeguards in `tachyon-utils-ts`)
  [PR 4017](https://git.xarth.tv/emerging-platforms/tachyon/pull/4017)

### tachyon-environment

- Split `EnvironmentContext` in `StaticEnvironmentContext` (including common and
  client info) and `DynamicEnvironmentContext` and update helpers. Also add
  `ClientConfigurableContext` for passing values like launcher version
  [PR 3848](https://git.xarth.tv/emerging-platforms/tachyon/pull/3848)
- User-agent handling is now safe in all environments
  [PR 3870](https://git.xarth.tv/emerging-platforms/tachyon/pull/3870)
- Add MobileWebPWA `Platform`
  [PR 3895](https://git.xarth.tv/emerging-platforms/tachyon/pull/3895)

### tachyon-event-reporter

- Classes like `ConsoleReporter` are converted to functions like
  `createConsoleReportEvent`; all event processing is moved into event-tracker;
  EventTrackerRoot now exposes configuration for individual report targets
  [PR 3870](https://git.xarth.tv/emerging-platforms/tachyon/pull/3870)
- `EventReporterRoot` accepts flume configuration and `logFlume` is exported
  [PR 3886](https://git.xarth.tv/emerging-platforms/tachyon/pull/3886)
- flume and spade configurations now support configurable batching windows and
  `useBeacon` is no longer necessary on individual event reports
  [PR 4002](https://git.xarth.tv/emerging-platforms/tachyon/pull/4002)
- flume configurations now expect `allowedEvents` allowlist of event names to be
  reported [PR 4004](https://git.xarth.tv/emerging-platforms/tachyon/pull/4004)

### tachyon-event-tracker

- `EventTrackerRoot` now requires a `browserAndOs` prop and applies
  `browser_name`, `browser_version`, `os_name`, `os_version` to all events
  [PR 3852](https://git.xarth.tv/emerging-platforms/tachyon/pull/3852)
- Added `device_code_flow` tracking event
  [PR 3772](https://git.xarth.tv/emerging-platforms/tachyon/pull/3772)
- All event processing now happens in event-tracker (moved from event-reporter)
  [PR 3870](https://git.xarth.tv/emerging-platforms/tachyon/pull/3870)
- `page_session_id` is now sent for all events
  [PR 3909](https://git.xarth.tv/emerging-platforms/tachyon/pull/3909)
- `client_offline` is now sent for `pageview` events
  [PR 3929](https://git.xarth.tv/emerging-platforms/tachyon/pull/3929)
- `Pageview` will now send `pageview` events when its' location or the
  `EventTrackerRoot` location changes. Previously this was triggered on mount.
  [PR 4003](https://git.xarth.tv/emerging-platforms/tachyon/pull/4003)

### tachyon-experiments

- More accurate type for `ExperimentGroup`
  [PR 3835](https://git.xarth.tv/emerging-platforms/tachyon/pull/3835)
- Add test utils for mocking in mount tests
  [PR 3846](https://git.xarth.tv/emerging-platforms/tachyon/pull/3846)
- Emitted events are now flattened to be event-tracker-compatible
  [PR 3870](https://git.xarth.tv/emerging-platforms/tachyon/pull/3870)
- Fall back to control group when missing experiment data. When this occurs, no
  experimental reporting occurs.
  [PR 3991](https://git.xarth.tv/emerging-platforms/tachyon/pull/3991)
- Move `getExperimentGroupsForUser` into `ExperimentRoot`
  [PR 3994](https://git.xarth.tv/emerging-platforms/tachyon/pull/3994)

### tachyon-latency-tracker

- Emitted events are now flattened to be event-tracker-compatible
  [PR 3870](https://git.xarth.tv/emerging-platforms/tachyon/pull/3870)
- Added `worker-waiting` to latency events
  [PR 4012](https://git.xarth.tv/emerging-platforms/tachyon/pull/4012)

### tachyon-modal

- packaged removed in favor of new modal components in Core UI 19
  [PR 3964](https://git.xarth.tv/emerging-platforms/tachyon/pull/3964)

### tachyon-more-ui

- Converted tv `StyleRoot` to use raw style tag and moved previous
  styled-components implementation to ScStyleRoot
  [PR 3830](https://git.xarth.tv/emerging-platforms/tachyon/pull/3830)
- Added `svgs` directory, which contains some re-usable Glow SVG image
  components
  [PR 3953](https://git.xarth.tv/emerging-platforms/tachyon/pull/3953)
- Twitch entity information compacted into `TwitchEntityInformationLinks` and
  `TwitchEntityInformationModal` using new Core UI 19 modal components
  [PR 3964](https://git.xarth.tv/emerging-platforms/tachyon/pull/3964)
- `transformCoreInteractiveProps` has been removed; it is no longer necessary
  after updates to Core UI
  [PR 3967](https://git.xarth.tv/emerging-platforms/tachyon/pull/3967)
- Added custom social media icons that are not present in Core UI
  [PR 4009](https://git.xarth.tv/emerging-platforms/tachyon/pull/4009)

### tachyon-next-types

- Removes `TachyonClassPage` (class page components are no longer supported) and
  adds `TachyonApiHandler` for API routes
  [PR 3886](https://git.xarth.tv/emerging-platforms/tachyon/pull/3886)

### tachyon-page-utils

- Adds `flumeHandler`
  [PR 3886](https://git.xarth.tv/emerging-platforms/tachyon/pull/3886)
- `flumeHandler` now rejects requests from non-Twitch domains
  [PR 4005](https://git.xarth.tv/emerging-platforms/tachyon/pull/4005)

### tachyon-pulsar-core

- Upgraded Player-Core to 1.2.0 and added `usePlaybackTime` to allow consumers
  to efficiently subscribe to playback time updates on Player-Core. Making
  `getDuration` available on `PlayerController` type.
  [PR 3816](https://git.xarth.tv/emerging-platforms/tachyon/pull/3816)
- Added `useMute` / `useVolume` custom hooks
  [PR 3825](https://git.xarth.tv/emerging-platforms/tachyon/pull/3825)
- Added `usePlaybackState` to allow consumers to efficiently subscribe to
  playback state updates on Player-Core.
  [PR 3822](https://git.xarth.tv/emerging-platforms/tachyon/pull/3822)
- Add a `lowQualityNoAds` prop for use with preview players that don't want to
  show preroll ads on them
  [PR 3900](https://git.xarth.tv/emerging-platforms/tachyon/pull/3900)
- Removed `onCaptions` prop and replaced with Context-based system through
  `ClosedCaptionsRoot` and `useClosedCaptions`
  [PR 3884](https://git.xarth.tv/emerging-platforms/tachyon/pull/3884)
- Added at `restart` playback helper method to `PlayerController`
  [PR 3928](https://git.xarth.tv/emerging-platforms/tachyon/pull/3928)
- Upgraded to 1.2.0.web-13. Player-Core's main JS API is now included directly
  in the package with optional support for serving its other WASM/ASM assets
  from your own CDN using the `assetUrls` prop.
  [PR 3907](https://git.xarth.tv/emerging-platforms/tachyon/pull/3970)

# tachyon-player-core-loader

- Removed, use `tachyon-pulsar-core` directly now that it no longer uses this
  package to lazy load the core JS API.
  [PR 3907](https://git.xarth.tv/emerging-platforms/tachyon/pull/3970)

### tachyon-relay

- Debug mode now exposes the relevant backing services, and `failServices` now
  requires debug mode
  [PR 3862](https://git.xarth.tv/emerging-platforms/tachyon/pull/3862)
- Migrate from x-device-id to device-id header
  [PR 3924](https://git.xarth.tv/emerging-platforms/tachyon/pull/3924)

### tachyon-spade-reporter

- Renamed to tachyon-event-reporter
  [PR 3870](https://git.xarth.tv/emerging-platforms/tachyon/pull/3870)

### tachyon-server-utils

- move `fetchDynamicSettings` to `tachyon-dynamic-settings` and removes server
  side dependency. Now asynchronous.
  [PR 3959](https://git.xarth.tv/emerging-platforms/tachyon/pull/3959)

### tachyon-utils

- MAX_COOKIE_AGE is now 390 days (~13 months) instead of 10 years
  [PR 3952](https://git.xarth.tv/emerging-platforms/tachyon/pull/3952)
- Fixed bug in `getCurrentTwitchDomain` where it would accept invalid domains
  [PR 4005](https://git.xarth.tv/emerging-platforms/tachyon/pull/4005)

### tachyon-utils-stdlib

- Adds `pick()`
  [PR 3886](https://git.xarth.tv/emerging-platforms/tachyon/pull/3886)

### tachyon-utils-ts

- Adds `isBoolean()`, `isNumber()`, `isString()`, `isNumberArray()`,
  `isStringArray()` typeguard functions
  [PR 4017](https://git.xarth.tv/emerging-platforms/tachyon/pull/4017)

## 22.0.0 (November 16, 2020)

### general

- All dependencies updated, including moving to TypeScript 4.0
  [PR 3561](https://git.xarth.tv/emerging-platforms/tachyon/pull/3561)
- All dependencies updated, including moving to new JSX transform
  [PR 3561](https://git.xarth.tv/emerging-platforms/tachyon/pull/3561)

### eslint-plugin-tachyon

- New package with custom lint rules
  [PR 3774](https://git.xarth.tv/emerging-platforms/tachyon/pull/3774)

### tachyon-chat

- `ChatPane` now exposes a callback for when it receives its first message
  [PR 3327](https://git.xarth.tv/emerging-platforms/tachyon/pull/3327)
- Fixed an issue with displaying international display names
  [PR 3468](https://git.xarth.tv/emerging-platforms/tachyon/pull/3468)
- User colors are now controlled via inline styles for better performance
  [PR 3492](https://git.xarth.tv/emerging-platforms/tachyon/pull/3492)
- Split out ui components into `tachyon-chat-ui` package

### tachyon-chat-ui

- New package containing chat ui components that were previously in tachyon-chat
  [PR 3635](https://git.xarth.tv/emerging-platforms/tachyon/pull/3635)

### tachyon-discovery

- Added `onRecommendationItemDisplay` to DiscoveryTracking API
  [PR 3296](https://git.xarth.tv/emerging-platforms/tachyon/pull/3296)
- Breaking change to `onRecommendationItemClick` arguments and now also emits a
  corresponding tracking event in addition to existing behavior of returning
  player event attribution fields
  [PR 3296](https://git.xarth.tv/emerging-platforms/tachyon/pull/3296)
- Removes improperly set alt tags for various content cards
  [PR 3479](https://git.xarth.tv/emerging-platforms/tachyon/pull/3479)
- Added `onSearchSuggestionRequest`, `onSearchSuggestionDisplay`, and
  `onSearchSuggestionClick` to the DiscoveryTracking API
  [PR 3550](https://git.xarth.tv/emerging-platforms/tachyon/pull/3550)
- Added missing tracking params from `onSearchSuggestionClick`
  [PR 3567](https://git.xarth.tv/emerging-platforms/tachyon/pull/3567)
- Added `srp_item_tracking_id`, `show_more` and `show_all` params to
  `SpadeSearchResultClick` and `SpadeSearchResultImpression`. Added
  `suggestion_position` and `suggestion_tracking_id` to
  `SpadeSearchEventQuerySubmit`. Change fallbacks to use `??` instead of `||`
  [PR 3572](https://git.xarth.tv/emerging-platforms/tachyon/pull/3572)
- Remove `time` field for `onSearchQuerySubmit` and `onSearchQueryResult` in the
  package [PR 3597](https://git.xarth.tv/emerging-platforms/tachyon/pull/3597)

### tachyon-dynamic-settings

- Configuration now properly supports dynamically choosing between different
  appGroups, apps, and appEnvironments and passes through all content
  [PR 3584](https://git.xarth.tv/emerging-platforms/tachyon/pull/3584)

### tachyon-experiments

- Converts old render-prop pattern to hooks in all context dependent components.
  [PR 3306](https://git.xarth.tv/emerging-platforms/tachyon/pull/3306)
- Exposes `useDangerousExperimentsConfig` for apps to consume in the rare case
  they need visibility directly into the active experiments and what group the
  user is currently in.
  [PR 3306](https://git.xarth.tv/emerging-platforms/tachyon/pull/3306)
- Adds convenience methods `getFriendlyExperimentName` and
  `getExperimentOverridesQueryParams`
  [PR 3306](https://git.xarth.tv/emerging-platforms/tachyon/pull/3306)
- Implements 'Magic Decoder Ring' project. There are many breaking changes --
  this should be considered the next major version of the experiment package.
  [PR 3760](https://git.xarth.tv/emerging-platforms/tachyon/pull/3760)

### tachyon-intl-server

- `prepareLocaleDataCache` is now async
  [PR 3561](https://git.xarth.tv/emerging-platforms/tachyon/pull/3561)

### tachyon-latency-tracker

- `useCustomLatency` hook now exported
  [PR 3327](https://git.xarth.tv/emerging-platforms/tachyon/pull/3327)
- All custom events: `playerAbandon`, `playerReady`, `playerPlaying`,
  `chatConnected`, `workerInstalled`, `workerControlling`, `workerActivated` now
  only report once per page.
  [PR 3628](https://git.xarth.tv/emerging-platforms/tachyon/pull/3628)

### tachyon-more-ui

- Adds a style override for `button:focus { outline: none!important; }`.
  [PR 3260](https://git.xarth.tv/emerging-platforms/tachyon/pull/3260)
- `QRCode` is now white-on-black (instead of purple-on-white)
  [PR 3315](https://git.xarth.tv/emerging-platforms/tachyon/pull/3315)
- Exports new styled-components `squareSize`
  [PR 3323](https://git.xarth.tv/emerging-platforms/tachyon/pull/3323)
- `Avatar` and `QRCode` now accept `sizePct` and `sizePx` in addition to sizeRem
  [PR 3323](https://git.xarth.tv/emerging-platforms/tachyon/pull/3323)
- `ClientOnly` and `QueryRendererLatencyManager` latency management components
  added [PR 3327](https://git.xarth.tv/emerging-platforms/tachyon/pull/3327)
- Exports `QRUrl` component
  [PR 3329](https://git.xarth.tv/emerging-platforms/tachyon/pull/3329)
- Exports `backgroundMatchedGradientDark` styled-components utility
  [PR 3334](https://git.xarth.tv/emerging-platforms/tachyon/pull/3334)
- `LatencyTrackedCardImage` no longer accepts an `alt` prop and makes the
  optional `latencyName` prop mandatory to improve screen reader output
  [PR 3479](https://git.xarth.tv/emerging-platforms/tachyon/pull/3479)
- `getStreamAccentColor` now accepts `undefined`
  [PR 3471](https://git.xarth.tv/emerging-platforms/tachyon/pull/3471)
- `Avatar` now renders fallback image when `userLogin` is missing
  [PR 3570](https://git.xarth.tv/emerging-platforms/tachyon/pull/3570)
- replaces StylesDark with StyleAll and removes StylesLight
  [PR 3574](https://git.xarth.tv/emerging-platforms/tachyon/pull/3574)
- Adds `formatTotalViewCount` internationalization method and renames
  `formatViewCount` to `formatLiveViewersCount`
  [PR 3777](https://git.xarth.tv/emerging-platforms/tachyon/pull/3777)

### tachyon-next-types

- exports `TachyonGetServerSideProps`
  [PR 3754](https://git.xarth.tv/emerging-platforms/tachyon/pull/3754)

### tachyon-notification

- new package that exports notification utilities
  [PR 3320](https://git.xarth.tv/emerging-platforms/tachyon/pull/3320)
- splits publisher and consumer hooks
  [PR 3371](https://git.xarth.tv/emerging-platforms/tachyon/pull/3371)
- makes notification meta mandatory and allow type control via generics
  [PR 3746](https://git.xarth.tv/emerging-platforms/tachyon/pull/3746)

### tachyon-page-utils

- `clipIsFound` now takes an optional second argument to support the legacy Clip
  URL path that includes a login value and will validate that it matches the
  broadcaster of the provided Clip data
  [PR 3314](https://git.xarth.tv/emerging-platforms/tachyon/pull/3314)
- Added a `getCurrentUser` utility for validating `currentUser` information from
  Relay [PR 3314](https://git.xarth.tv/emerging-platforms/tachyon/pull/3314)
- Rename `noopPageviewTracking` to `defaultPageviewTracking`
  [PR 3359](https://git.xarth.tv/emerging-platforms/tachyon/pull/3359)
- Add `useErrorPath` helper for managing `_app` error path handling. This isn't
  a great fit for this package (low cohesion with the other utils) but seemed
  the best place for now.
  [PR 3532](https://git.xarth.tv/emerging-platforms/tachyon/pull/3532)
- Add `_error` and `not-found` helpers
  [PR 3538](https://git.xarth.tv/emerging-platforms/tachyon/pull/3538)
- Add Channel / Viewer Pulsar param mappers (`pulsarViewer`,
  `channelPulsarParams`) and test utils for consumers
  (`mockPulsarChannelFragment`, `mockPlayingPulsarChannel`)
  [PR 3591](https://git.xarth.tv/emerging-platforms/tachyon/pull/3591).
- Add Vod Pulsar param mapper for `vodPulsarParams`
  [PR 3603](https://git.xarth.tv/emerging-platforms/tachyon/pull/3603)
- Add Channel / Stream restriction management / detection util via
  `useRestrictions`
  [PR 3601](https://git.xarth.tv/emerging-platforms/tachyon/pull/3601)
- Add Clip Pulsar param mapper (`clipPulsarParams`)
  [PR 3622](https://git.xarth.tv/emerging-platforms/tachyon/pull/3622)

### tachyon-player-core-loader

- `getMediaPlayer` now accepts `logLevel` in its `GetMediaPlayerOpts`
  [PR 3444](https://git.xarth.tv/emerging-platforms/tachyon/pull/3444)
- Upgraded to load Player-Core 1.0.1
  [PR 3388](https://git.xarth.tv/emerging-platforms/tachyon/pull/3388)

### tachyon-polyfill

- update to v3 of Twitch's polyfill service
  [PR 3578](https://git.xarth.tv/emerging-platforms/tachyon/pull/3578)

### tachyon-pulsar-core

- Now sets "pulsar" as player_type for player-core
  [PR 3426](https://git.xarth.tv/emerging-platforms/tachyon/pull/3426)
- Device ID is now always required to be passed to Player-Core
  [PR 3219](https://git.xarth.tv/emerging-platforms/tachyon/pull/3219)
- `debugMode` prop allows turning on player-core debug logging and also attaches
  mediaPlayerInstance to window for inspection
  [PR 3444](https://git.xarth.tv/emerging-platforms/tachyon/pull/3444)
- Adds optional `playbackAccessToken` to Vod and Stream Param objects to
  proactively provide Player-Core with a manifest URL rather than deferring to
  it to create one
  [PR 3632](https://git.xarth.tv/emerging-platforms/tachyon/pull/3632)
- Exposed `PlayerRoot` & `usePlayer` allowing consumers to interact with
  `PuslarCoreRef` without needing to directly manage the ref
  [PR 3765](https://git.xarth.tv/emerging-platforms/tachyon/pull/3765)
- Renamed a number of lifecycle props to no longer overlap similarly named
  tracking events `onVideoError` => `onError`, `onVideoPlayer` =>
  `onContentPlay`, `onBufferEmpty` => `onContentBuffering`. `onBufferRefill` has
  been removed.
  [PR 3763](https://git.xarth.tv/emerging-platforms/tachyon/pull/3763)

### tachyon-relay

- Adds `window.getTachyonRelayStore` which can be called in any app to output
  the relay store in the console for easy visibility.
  [PR 3309](https://git.xarth.tv/emerging-platforms/tachyon/pull/3309)
- Adds `isValidQueryResponse` helper / type-guard for narrowing "unknown"
  QueryResponse type from Relay
  [PR 3316](https://git.xarth.tv/emerging-platforms/tachyon/pull/3316)
- `useMutation` now requires an error handler to be provided for failed
  [PR 3348](https://git.xarth.tv/emerging-platforms/tachyon/pull/3348)
- Add `nonFatalErrorsHandler` option to relay environment to communicate when a
  non fatal GQL error has occurred. The handler is invoked with the `errors`
  array from the GQL response.
  [PR 3511](https://git.xarth.tv/emerging-platforms/tachyon/pull/3511)
- Add `backendServices` list
  [PR 3631](https://git.xarth.tv/emerging-platforms/tachyon/pull/3631)
- Remove `isGarbageObject` export. Clients should use `isValidObject` instead.
  [PR 3732](https://git.xarth.tv/emerging-platforms/tachyon/pull/3732)

### tachyon-server-utils

- Exports `setCookieDomainOnServer` for supporting staging environments
  [PR 3461](https://git.xarth.tv/emerging-platforms/tachyon/pull/3461)
- Remove `api` and `api/*` paths from `badRequestManager`
  [PR 3539](https://git.xarth.tv/emerging-platforms/tachyon/pull/3539)
- Remove `errorTestQueryParam` from `badRequestManager`
  [PR 3538](https://git.xarth.tv/emerging-platforms/tachyon/pull/3538)
- Add `getExperimentBucket`
  [PR 3760](https://git.xarth.tv/emerging-platforms/tachyon/pull/3760)

### tachyon-spade-reporter

- Add `client_time` to all events
  [PR 3416](https://git.xarth.tv/emerging-platforms/tachyon/pull/3416)

### tachyon-test-utils

- Add dom event helpers
  [PR 3732](https://git.xarth.tv/emerging-platforms/tachyon/pull/3732)

### tachyon-tv-nav

- Prevents default event handler propagation for D-pad navigation.
  [PR 3447](https://git.xarth.tv/emerging-platforms/tachyon/pull/3447)
- Changes navigationKeys in root with customKeyMap as this can now be used for
  more than directional nav.
  [PR 3549](https://git.xarth.tv/emerging-platforms/tachyon/pull/3549)

### tachyon-utils

- `reduceToNonNullNodes*` now handles missing argument array
  [PR 3347](https://git.xarth.tv/emerging-platforms/tachyon/pull/3347)
- `getCurrentTwitchDomain` no longer supports twitch.tech domains and handles
  `undefined` param
  [PR 3461](https://git.xarth.tv/emerging-platforms/tachyon/pull/3461)
- `getFormattedUserDisplayName` now accepts `undefined` `displayName`s
  [PR 3471](https://git.xarth.tv/emerging-platforms/tachyon/pull/3471)
- `getFormattedUserDisplayName` now accepts a `null` argument
  [PR 3501](https://git.xarth.tv/emerging-platforms/tachyon/pull/3501)
- `getFormattedUserDisplayName` has been updated to no longer accept nullable
  login / displayName fields to reflect GQL schema changes. Similarly
  `safeLogin` no longer accepts a `null` login. `getUserDisplayNameData ` was
  removed [PR 3615](https://git.xarth.tv/emerging-platforms/tachyon/pull/3615).

### tachyon-utils-hooks

- Moves callback stability into `usePoll`. Moves poll parameters into an options
  object. [PR 3745](https://git.xarth.tv/emerging-platforms/tachyon/pull/3745)
- Add `useMountedState` to track mount status. Useful for not invoking
  `setState` calls after asynchronous actions.
  [PR 3745](https://git.xarth.tv/emerging-platforms/tachyon/pull/3745)

### tachyon-utils-ts

- `Enum.convertValueFromExternal` handles `undefined` and `null` for `value`
  param [PR 3461](https://git.xarth.tv/emerging-platforms/tachyon/pull/3461)
- Adds `mutableDeep` which allow for recursive removal of `readonly` fields from
  a type [PR 3603](https://git.xarth.tv/emerging-platforms/tachyon/pull/3603)

### tachyon-utils-stdlib

- Add `kebabCase`, `titleCase`, and `containsSpecialCharacters`
  [PR 3615](https://git.xarth.tv/emerging-platforms/tachyon/pull/3615)
- Moves poll parameters into an options object.
  [PR 3745](https://git.xarth.tv/emerging-platforms/tachyon/pull/3745)

## 21.0.0 (July 22, 2020)

### general

- All dependencies updated
  [PR 3232](https://git.xarth.tv/emerging-platforms/tachyon/pull/3232)

### tachyon-discovery

- Generalizes `useSearchImpression` as `useCallbackMemoizedByKey` and moves it
  to `tachyon-utils-hooks`.
  [PR 3150](https://git.xarth.tv/emerging-platforms/tachyon/pull/3150)

### tachyon-environment

- Adds `isLikelyWebView` agentHelper which can be used to determine if a given
  `clientEnv` is likely to be a webview.
  [PR 3047](https://git.xarth.tv/emerging-platforms/tachyon/pull/3047)
- Platform enum moved from `tachyon-event-tracker`.
  [PR 3200](https://git.xarth.tv/emerging-platforms/tachyon/pull/3200)
- `EnvironmentRootProps` `platform` prop is now either a static `Platform` value
  or a function that takes `AgentInfo` and returns a `Platform` value to enable
  UA-based dynamic platform values.
  [PR 3200](https://git.xarth.tv/emerging-platforms/tachyon/pull/3200)

### tachyon-event-tracker

- Platform enum moved to `tachyon-event-tracker`.
  [PR 3200](https://git.xarth.tv/emerging-platforms/tachyon/pull/3200)

### tachyon-logger

- Add `onUnhandledError` handler
  [PR 3140](https://git.xarth.tv/emerging-platforms/tachyon/pull/3140)

### tachyon-more-ui

- Convert `ShadowedSVG` to use `heightRem` and `widthRem` instead of px variants
  [PR 3199](https://git.xarth.tv/emerging-platforms/tachyon/pull/3199)
- Add `Avatar` that overrides `size` with `rem` instead of fixed `px` sizes
  [PR 3199](https://git.xarth.tv/emerging-platforms/tachyon/pull/3199)
- Add `tv` directory that exports `StyleRoot` and common config for use across
  Starshot and Laser Array.
  [PR 3199](https://git.xarth.tv/emerging-platforms/tachyon/pull/3199)
- Image utility functions now accept optional final parameter to allow falling
  back to 404 image. srcSet image width lists have also been updated.
  [PR 3224](https://git.xarth.tv/emerging-platforms/tachyon/pull/3224)
- Updates the background color of the QR code to match Twitch white and a
  wrapper to simplify styling including some padding around the QR code.
  [PR 3226](https://git.xarth.tv/emerging-platforms/tachyon/pull/3226)
- Update QRCode to use `sizeRem` instead of `size`
  [PR 3256](https://git.xarth.tv/emerging-platforms/tachyon/pull/3256)

### tachyon-page-utils

- Export `BroadcastType` utility type for mirroring the GraphQL union type in
  non-GraphQL-connected locations
  [PR 3139](https://git.xarth.tv/emerging-platforms/tachyon/pull/3139)
- Add `noop` helper to aid package and pattern discoverability
  [PR 3227](https://git.xarth.tv/emerging-platforms/tachyon/pull/3227)
- Add `gameGetInitialProps`
  [PR 3227](https://git.xarth.tv/emerging-platforms/tachyon/pull/3227)
- Add `channelIsFound`
  [PR 3250](https://git.xarth.tv/emerging-platforms/tachyon/pull/3250)

### tachyon-pulsar-core

- Update Player Core to 0.9.9
  [PR 3179](https://git.xarth.tv/emerging-platforms/tachyon/pull/3179)
- Set the player platform from PulsarCore's `environment` props.
  [PR 3181](https://git.xarth.tv/emerging-platforms/tachyon/pull/3181)
- Tracking events no longer suppress/clobber device_id and platform values.
  [PR 3200](https://git.xarth.tv/emerging-platforms/tachyon/pull/3200)

### tachyon-spade-reporter

- Add `getUserTracking` to `AppReporter` constructor to send user tracking data
  [PR 3284](https://git.xarth.tv/emerging-platforms/tachyon/pull/3284)
- Remove `DynamicSpadeProperties` and `CommonSpadeProperties` exports
  [PR 3284](https://git.xarth.tv/emerging-platforms/tachyon/pull/3284)

### tachyon-tv-nav

- A huge update with minimal API changes that creates centralized focus
  management and `useFocus`/`useFocusArea` hooks for better UX and performance.
  [PR 3105](https://git.xarth.tv/emerging-platforms/tachyon/pull/3105)
- Navigation areas now have a `takeFocusOnFirstRender` prop that allows them to
  ensure they are focused when they come on-screen.
  [PR 3225](https://git.xarth.tv/emerging-platforms/tachyon/pull/3225)
- `useFocus` now supports ability to move focus to the consuming element via a
  newly exposed `takeFocus` function
  [PR 3270](https://git.xarth.tv/emerging-platforms/tachyon/pull/3270)

### tachyon-utils-hooks

- Adds `useCallbackMemoizedByKey` which is useful for de-duping callbacks that
  happen on `useEffect`.
  [PR 3150](https://git.xarth.tv/emerging-platforms/tachyon/pull/3150)
- Adds `usePoll` to expose `poll` from `utils-std-lib`
  [PR 3273](https://git.xarth.tv/emerging-platforms/tachyon/pull/3273)

## 20.0.0 (May 28, 2020)

### branch-io

- Removes package, as it is replaced by `react-branch`
  [PR 3131](https://git.xarth.tv/emerging-platforms/tachyon/pull/3131)

### tachyon-auth

- Add `token` to `useCurrentUser` hook
  [PR 3097](https://git.xarth.tv/emerging-platforms/tachyon/pull/3097)

### tachyon-auth-server

- Add `clearAuthTokenOnServer`
  [PR 2977](https://git.xarth.tv/emerging-platforms/tachyon/pull/2977)

### tachyon-more-ui

- Rename `entityInformation` function to `getEntityInformation`
  [PR 3130](https://git.xarth.tv/emerging-platforms/tachyon/pull/3130)

### tachyon-player-core-loader

- Package promoted from private status and published
  [PR 3132](https://git.xarth.tv/emerging-platforms/tachyon/pull/3132)

### tachyon-pulsar-core

- Add `authToken` to PulsarCore's `environment` props, enabling gated content.
  [PR 3096](https://git.xarth.tv/emerging-platforms/tachyon/pull/3096)
- Package promoted from private status and published
  [PR 3132](https://git.xarth.tv/emerging-platforms/tachyon/pull/3132)

### tachyon-type-library

- Add `AnyFunction` and `CancelableFunction`
  [PR 3118](https://git.xarth.tv/emerging-platforms/tachyon/pull/3118)

### tachyon-utils-hooks

- `useUnmount` introduced
  [PR 3118](https://git.xarth.tv/emerging-platforms/tachyon/pull/3118)
- `useImmutableCallback` introduced
  [PR 3089](https://git.xarth.tv/emerging-platforms/tachyon/pull/3089)

### tachyon-server-utils

- Add `clearCookieValueOnServer`
  [PR 3097](https://git.xarth.tv/emerging-platforms/tachyon/pull/3097)

### tachyon-relay

- Update `authorization` to an object with `token` and `unauthorizedHandler`
  keys. The `unauthorizedHandler` will be invoked if the GraphQL endpoint
  returns a 401
  [PR 3097](https://git.xarth.tv/emerging-platforms/tachyon/pull/3097)
- Add `useMutation` helper
  [PR 3227](https://git.xarth.tv/emerging-platforms/tachyon/pull/3227)

## 19.0.0 (May 7, 2020)

### General

- all React components in all packages now have displayName set
  [PR 2893](https://git.xarth.tv/emerging-platforms/tachyon/pull/2893)
- updated React peer dependency version for packages that export hooks
  [PR 2903](https://git.xarth.tv/emerging-platforms/tachyon/pull/2903/)

### react-branch

- New package that exposes the official
  [`branch-sdk`](https://www.npmjs.com/package/branch-sdk) to consumers via
  hooks. [PR 2963](https://git.xarth.tv/emerging-platforms/tachyon/pull/2963)

### tachyon-auth

- new package that exports authentication utilities
  [PR 2977](https://git.xarth.tv/emerging-platforms/tachyon/pull/2977)

### tachyon-auth-server

- SSR companion package to tachyon-auth
  [PR 2977](https://git.xarth.tv/emerging-platforms/tachyon/pull/2977)

### tachyon-dynamic-settings

- Now uses `AppEnvironment` from `tachyon-environment` and no longer exports
  `Environment` enum
  [PR 2991](https://git.xarth.tv/emerging-platforms/tachyon/pull/2991)

### tachyon-environment

- Now accepts and forwards `appEnvironment` in common data, and exports
  `AppEnvironment` type
  [PR 2991](https://git.xarth.tv/emerging-platforms/tachyon/pull/2991)

### tachyon-event-tracker

- New "interaction" value of "impression" to simplify click through tracking
  [PR 3014](https://git.xarth.tv/emerging-platforms/tachyon/pull/3014)
- Replaces `asTrackedListItem` HOC with `useTrackedListItem` hook
  [PR3045](https://git.xarth.tv/emerging-platforms/tachyon/pull/3045)

### tachyon-es6-deps-list

- New package that lists known es6 sub-dependencies of the monorepo
  [PR 3006](https://git.xarth.tv/emerging-platforms/tachyon/pull/3006)

### tachyon-event-tracker

- Removed imperative Pageview tracking React APIs (withPageviewTracking,
  usePageviewTracking)
  [PR 2906](https://git.xarth.tv/emerging-platforms/tachyon/pull/2906)

### tachyon-intl

- export type `TwitchIntl`
  [PR 2927](https://git.xarth.tv/emerging-platforms/tachyon/pull/2927)

### tachyon-logger

- rewritten to be backed by Sentry instead of Sentinel/Savant
  [PR 2976](https://git.xarth.tv/emerging-platforms/tachyon/pull/2976)
- exposes the ability to ignore or throttle specific messages reporting
  [PR 3004](https://git.xarth.tv/emerging-platforms/tachyon/pull/3004)

### tachyon-more-ui

- adds `QRCode` component with Twitch branding
  [PR 2959](https://git.xarth.tv/emerging-platforms/tachyon/pull/2959)
- adds `formatFollowers`, `formatLastLive`, `formatOffline`
  [PR 2927](https://git.xarth.tv/emerging-platforms/tachyon/pull/2927)
- adds `ShadowedSVG` component
  [PR 2877](https://git.xarth.tv/emerging-platforms/tachyon/pull/2877)
- rename `IndicatorType` => `StreamType`, replace `streamTypeToIndicatorType`
  with `getStreamType` which encapsulates hosting detection.
  [PR 2924](https://git.xarth.tv/emerging-platforms/tachyon/pull/2924)

### tachyon-next-types

- add required `pageviewTracking` method to `TachyonPage` and `TachyonPageType`
  [PR 2956](https://git.xarth.tv/emerging-platforms/tachyon/pull/2956)
- `TachyonPage` and `TachyonAppContext` now support extending
  `TachyonPageContext` with app-specific extensions
  [PR 2991](https://git.xarth.tv/emerging-platforms/tachyon/pull/2991)

### tachyon-pulsar-core

- expose `getPosition` and `seekTo` on `PulsarCoreRef`
  [PR 2907](https://git.xarth.tv/emerging-platforms/tachyon/pull/2907)

### tachyon-relay

- Add `authorization` option to relay environment to enable authenticated GQL
  requests [PR 3056](https://git.xarth.tv/emerging-platforms/tachyon/pull/3056)
- exports `isValidObject` convenience method for checking GQL responses
  [PR 2956](https://git.xarth.tv/emerging-platforms/tachyon/pull/2956)
- exports 'FCWithQuery' type for components that do their own queries
  [PR 2893](https://git.xarth.tv/emerging-platforms/tachyon/pull/2893)

### tachyon-spade-reporter

- exports 'useSpadeReporter'
  [PR 2910](https://git.xarth.tv/emerging-platforms/tachyon/pull/2910)
- SpadeReporter now retries once for failed reports
  [PR 2957](https://git.xarth.tv/emerging-platforms/tachyon/pull/2957)

### tachyon-server-utils

- exports `tachyonServerMiddleware`
  [PR 2928](https://git.xarth.tv/emerging-platforms/tachyon/pull/2928)
- exports `readIniFile` and `getTachyonEnvVar` helpers
  [PR 2976](https://git.xarth.tv/emerging-platforms/tachyon/pull/2976)
- `tachyonServerMiddleware` `channelPageAliasManager` is replaced by generic
  `pageAliasManager` that takes regexes and builder functions to handle multiple
  pages [PR 3029](https://git.xarth.tv/emerging-platforms/tachyon/pull/3029)

### tachyon-type-library

- `DistributedOmit` helper added
  [PR 2939](https://git.xarth.tv/emerging-platforms/tachyon/pull/2939)

### tachyon-utils

- changes `generateCookieOpts` default to SameSite=None
  [PR 2867](https://git.xarth.tv/emerging-platforms/tachyon/pull/2867)

### tachyon-utils-hooks

- `useAsync` will now be retriggered if invoked with a new function reference
  [PR 2977](https://git.xarth.tv/emerging-platforms/tachyon/pull/2977)
- Remove `useContainerActivity`
  [PR 2942](https://git.xarth.tv/emerging-platforms/tachyon/pull/2942)
- Add `useForceUpdate`
  [PR 2942](https://git.xarth.tv/emerging-platforms/tachyon/pull/2942)
- Fix `useStorage` for Chrome's "Block third-party cookies" setting
  [PR 3005](https://git.xarth.tv/emerging-platforms/tachyon/pull/3005)
- Add `useTimeout`
  [PR 2964](https://git.xarth.tv/emerging-platforms/tachyon/pull/2964)
- Add `useInterval`
  [PR 2964](https://git.xarth.tv/emerging-platforms/tachyon/pull/2964)

### tachyon-utils-stdlib

- exports `poll`
  [PR 2977](https://git.xarth.tv/emerging-platforms/tachyon/pull/2977)
- exports `once`
  [PR 2903](https://git.xarth.tv/emerging-platforms/tachyon/pull/2903)

## 18.0.0 (Mar 25, 2020)

### General

- update to TS 3.8 along with other dependency updates
  [PR 2835](https://git.xarth.tv/emerging-platforms/tachyon/pull/2835)

### tachyon-discovery

- add `useDiscoveryTracking` to consume DiscoveryTrackingRoot
  [PR 2818](https://git.xarth.tv/emerging-platforms/tachyon/pull/2818)

### tachyon-intl

- refactors the `<TachyonIntlRoot>` interface to support client side only apps
  [PR 2754](https://git.xarth.tv/emerging-platforms/tachyon/pull/2754)

### tachyon-logger

- `setupClientErrorHandling` now takes an optional second argument that allows
  consumers to discard specific errors
  [PR 2819](https://git.xarth.tv/emerging-platforms/tachyon/pull/2819)

### tachyon-latency-tracker

- component-level reporting is now based off Math.random() instead of
  getRandomValue
  [PR 2707](https://git.xarth.tv/emerging-platforms/tachyon/pull/2707)
- reporting of events like app-boot and first-byte are now deferred until after
  first render
  [PR 2704](https://git.xarth.tv/emerging-platforms/tachyon/pull/2704)

### tachyon-more-ui

- replaces StyleAll with StylesLight and StylesDark (though not intended for
  general use)
  [PR 2747](https://git.xarth.tv/emerging-platforms/tachyon/pull/2747)

### tachyon-modal

- new package that exports `ModalProvider` and `ModalWrapper` components to
  allow for a common modal experience using portals and context
  [PR 2670](https://git.xarth.tv/emerging-platforms/tachyon/pull/2670)

### tachyon-player-core-loader

- remove exported `PulsarCorePreload`. Add `CLIENT_URL`, `ASMJS_WORKER_URL`, and
  `WASM_WORKER_URL` exports
  [PR 2839](https://git.xarth.tv/emerging-platforms/tachyon/pull/2839)

### tachyon-pulsar-core

- replace `PulsarCorePreload` with `PulsarCorePreloadWASM` and
  `PulsarCorePreloadASMJS`
  [PR 2839](https://git.xarth.tv/emerging-platforms/tachyon/pull/2839)

### tachyon-test-utils

- Add `visibility` for testing DOM `visibilitychange`s
  [PR 2420](https://git.xarth.tv/emerging-platforms/tachyon/pull/2420)

### tachyon-tv-nav

- Add pagination for `HorizontalNav`. A `pageSize` prop is now available, as are
  `pageNext` and `pagePrev` functions to increment or decrement the focus by
  `pageSize`.
  [PR 2845](https://git.xarth.tv/emerging-platforms/tachyon/pull/2845)

### tachyon-utils-hooks

- adds `useAsync` for life cycle management of asynchronous functions
  [PR 2705](https://git.xarth.tv/emerging-platforms/tachyon/pull/2705)
- removes `useDebouncedValue`
  [PR 2685](https://git.xarth.tv/emerging-platforms/tachyon/pull/2685)
- adds `useDebouncedState`
  [PR 2685](https://git.xarth.tv/emerging-platforms/tachyon/pull/2685)
- adds `useDelayed` hook for showing content after a period of time passes
  [PR 2671](https://git.xarth.tv/emerging-platforms/tachyon/pull/2671)

### tachyon-more-ui

- export new `TwitchEntityInformationModal` component that can be used already
  composed or composed by the consumer
  [PR 2662](https://git.xarth.tv/emerging-platforms/tachyon/pull/2662)

### tachyon-utils-stdlib

- `isValidHex` added that checks whether a string is a valid hexcode or not
  [PR 2615](https://git.xarth.tv/emerging-platforms/tachyon/pull/2615)

## 17.0.0 (Feb 18, 2020)

### tachyon-chat

- export new `ChatPane` which provides the standard Twitch Chat layout behavior.
  Adjusted ChatRoot to allow for custom message buffer size.
  [PR 2634](https://git.xarth.tv/emerging-platforms/tachyon/pull/2634)

### tachyon-environment

- export new `getDataScienceBrowserAndOs` util, `getOtherEnvMock` now takes
  optional user-agent string
  [PR 2554](https://git.xarth.tv/emerging-platforms/tachyon/pull/2554)

### tachyon-event-tracker

- custom tracking functions/types now accept generics to allow tighter typing
  [PR 2616](https://git.xarth.tv/emerging-platforms/tachyon/pull/2616)

### tachyon-more-ui

- add noopLinkProps for CoreUI components that require a link
  [PR 2612](https://git.xarth.tv/emerging-platforms/tachyon/pull/2612)

### tachyon-type-library

- `KeysForValuesOfType` helper added
  [PR 2616](https://git.xarth.tv/emerging-platforms/tachyon/pull/2616)

### tachyon-utils

- `memoize` removed; tachyon-utils-mem library now reexported with expanded
  options [PR 2616](https://git.xarth.tv/emerging-platforms/tachyon/pull/2616)

### tachyon-utils-mem

- new library with simple, deep, lead object keys, and custom memoization
  [PR 2616](https://git.xarth.tv/emerging-platforms/tachyon/pull/2616)

### tachyon-utils-stdlib

- adds keyboard event helpers for compatibility with legacy browsers such as
  IE11 [PR 2610](https://git.xarth.tv/emerging-platforms/tachyon/pull/2610)

## 16.0.0 (Feb 4, 2020)

### tachyon-dynamic-settings

- initial creation of dynamic settings library, providing the rotating spade url
  [PR 2418](https://git.xarth.tv/emerging-platforms/tachyon/pull/2418)
- add initial team setting functionality
  [PR 2438](https://git.xarth.tv/emerging-platforms/tachyon/pull/2438)

### tachyon-environment

- network status tracking can now be disabled via `networkStatusDebounceWait`
  [PR 2534](https://git.xarth.tv/emerging-platforms/tachyon/pull/2534)

### tachyon-event-tracker

- Provide a "Platform" map for various Twitch tracking platform values.
- The function returned by `useCustomTracking` is now stable across rerenders.
  [PR 2504](https://git.xarth.tv/emerging-platforms/tachyon/pull/2504)

### tachyon-experiments

- 100% treatment experiments are now converted to 100% control in local dev
  [PR 2352](https://git.xarth.tv/emerging-platforms/tachyon/pull/2352)

### tachyon-latency-tracker

- now sends a benchmark_custom_event with key "connect-end" to measure the time
  it takes to establish a TCP connection to the requested DNS for the app
  [PR 2443](https://git.xarth.tv/emerging-platforms/tachyon/pull/2443)

### tachyon-more-ui

- common StreamTypeIndicator component and utils
  [PR 2383](https://git.xarth.tv/emerging-platforms/tachyon/pull/2383)

### tachyon-environment

- experiment and locale info removed from default `TachyonRequestExtension`
  [PR 2534](https://git.xarth.tv/emerging-platforms/tachyon/pull/2534)

### tachyon-package-builder

- update TS error output with more info
  [PR 2449](https://git.xarth.tv/emerging-platforms/tachyon/pull/2449)

### tachyon-pulsar-core

- add `autoMute` optional property to specify whether video should start muted
  or unmuted. Defaults to unmuted
  [PR 2475](https://git.xarth.tv/emerging-platforms/tachyon/pull/2475)
- add `initialVolume` optional property to specify the volume at load
  [PR 2475](https://git.xarth.tv/emerging-platforms/tachyon/pull/2475)

### tachyon-relay

- add `serverHttpsAgent` option to relay configuration
  [PR 2471](https://git.xarth.tv/emerging-platforms/tachyon/pull/2471)

### tachyon-server-utils

- add `fetchDynamicSettings` and remove `fetchSpadeURI`
  [PR 2418](https://git.xarth.tv/emerging-platforms/tachyon/pull/2418)
- adds `getCookieValueOnServer` and `setCookieValueOnServer`
  [PR 2454](https://git.xarth.tv/emerging-platforms/tachyon/pull/2454)

### tachyon-spade-reporter

- adjust `spadeURI` prop to `spadeUrl`
  [PR 2418](https://git.xarth.tv/emerging-platforms/tachyon/pull/2418)

### tachyon-test-utils

- Added randomId and randomType generator
  [PR 2420](https://git.xarth.tv/emerging-platforms/tachyon/pull/2420)
- `getCurrentTwitchDomain` now matches `twitch.a2z.com`
  [PR 2534](https://git.xarth.tv/emerging-platforms/tachyon/pull/2534)

### tachyon-type-library

- adds `IsolateGqlUnionType` and re-exports all of `type-fest` library
  [PR 2404](https://git.xarth.tv/emerging-platforms/tachyon/pull/2404)

- adds `NonEmptyArray` and `OmitRefType`
  [PR 2463](https://git.xarth.tv/emerging-platforms/tachyon/pull/2463)

### tachyon-utils

- convert storageProxy's length to be a dynamic getter
  [PR 2364](https://git.xarth.tv/emerging-platforms/tachyon/pull/2364)
- adds `getGameDisplayName` that takes a Game and an optional default string
  [PR 2436](https://git.xarth.tv/emerging-platforms/tachyon/pull/2436)
- adds `generateCookieOpts` which defaults to SameSite=lax and Secure
  [PR 2454](https://git.xarth.tv/emerging-platforms/tachyon/pull/2454)
- adds `reduceToNonNullNodesWithTrackingID`
  [PR 2504](https://git.xarth.tv/emerging-platforms/tachyon/pull/2504)

### tachyon-utils-hooks

- create package that exports the hooks previously in tachyon-utils
  [PR 2433](https://git.xarth.tv/emerging-platforms/tachyon/pull/2433)
- copy the `useEvent` hook from
  [`react-use`](https://github.com/streamich/react-use)
  [PR 2433](https://git.xarth.tv/emerging-platforms/tachyon/pull/2433)
- `useContainerActivity` hook for determining when a container is being
  interacted with
  [PR 2431](https://git.xarth.tv/emerging-platforms/tachyon/pull/2431)
- adds `useDebounce`
  [PR 2468](https://git.xarth.tv/emerging-platforms/tachyon/pull/2469)
- adds `useDebouncedValue`
  [PR 2468](https://git.xarth.tv/emerging-platforms/tachyon/pull/2469)
- adds `useThrottle` and `usePrevious`
  [PR 2499](https://git.xarth.tv/emerging-platforms/tachyon/pull/2499)

### tachyon-utils-stdlib

- create package that exports stdlib functionality
  [PR 2468](https://git.xarth.tv/emerging-platforms/tachyon/pull/2469)
- adds `debounce`
  [PR 2468](https://git.xarth.tv/emerging-platforms/tachyon/pull/2469)
- adds `throttle`
  [PR 2499](https://git.xarth.tv/emerging-platforms/tachyon/pull/2499)

### tachyon-utils-ts

- add `exhaustedCase` for working with enums and similar in switch statements
  [PR 2383](https://git.xarth.tv/emerging-platforms/tachyon/pull/2383)

## 15.1.2 (Dec 4, 2019)

### discovery

- UI now based on Core UI v10
  [PR 2292](https://git.xarth.tv/emerging-platforms/tachyon/pull/2292)

### tachyon-event-tracker

- added `useInteractionTracking` and `useCustomTracking` hooks
  [PR 2316](https://git.xarth.tv/emerging-platforms/tachyon/pull/2316)
- fixes `asTrackedListItem` props to guarantee that `interactionContent` will be
  provided [PR 2288](https://git.xarth.tv/emerging-platforms/tachyon/pull/2288)

### tachyon-intl

- adds `<LocaleGate>` component to be used to gate features based on a list of
  country-codes.
  [PR 2235](https://git.xarth.tv/emerging-platforms/tachyon/pull/2235) &
  [PR 2283](https://git.xarth.tv/emerging-platforms/tachyon/pull/2283) &
  [PR 2289](https://git.xarth.tv/emerging-platforms/tachyon/pull/2289)

### tachyon-utils-ts

- adds `Enum.entries` utility method
  [PR 2288](https://git.xarth.tv/emerging-platforms/tachyon/pull/2288)
- moved `createDeviceIDOnServer` and `getDeviceIDOnServer` to
  `tachyon-server-utils` to avoid Express / Node dependencies for CSR consumers
  [PR 2338](https://git.xarth.tv/emerging-platforms/tachyon/pull/2338)

### tachyon-server-utils

- adds `createDeviceIDOnServer` and `getDeviceIDOnServer` moved from
  `tachyon-utils`
  [PR 2338](https://git.xarth.tv/emerging-platforms/tachyon/pull/2338)

### misc

- dependency updates
  [PR 2295](https://git.xarth.tv/emerging-platforms/tachyon/pull/2295)
- dependency updates
  [PR 2266](https://git.xarth.tv/emerging-platforms/tachyon/pull/2266)
- dependency updates
  [PR 2259](https://git.xarth.tv/emerging-platforms/tachyon/pull/2259)
- dependency updates
  [PR 2254](https://git.xarth.tv/emerging-platforms/tachyon/pull/2254)

---

## 15.0.0 (Nov 4, 2019)

### tachyon-experiments

- adds processMinixperimentResponseWithAllTreatmentWarning for generating
  warnings when treatment groups are set to 100%
  [PR 2242](https://git.xarth.tv/emerging-platforms/tachyon/pull/2242)

### tachyon-intl

- expose SUPPORTED_LOCALE_DATA, SUPPORTED_LOCALES, and SUPPORTED_LANGUAGE_CODES
  from tachyon-intl for consumption in browser
  [PR 2194](https://git.xarth.tv/emerging-platforms/tachyon/pull/2194)

### tachyon-search => tachyon-discovery

- add generic discovery tracking and rename to tachyon-discovery to reflect
  broader capabilities
  [PR 2191](https://git.xarth.tv/emerging-platforms/tachyon/pull/2191)
- Ensure channel search results have a name
  [PR 2184](https://git.xarth.tv/emerging-platforms/tachyon/pull/2184)

### tachyon-server-utils

- change fetchSpadeURI to guarantee valid, fully-formed URIS are returned (adds
  Node URL dependency)
  [PR 2198](https://git.xarth.tv/emerging-platforms/tachyon/pull/2198)
- Add failing url to fetcher error logs
  [PR 2180](https://git.xarth.tv/emerging-platforms/tachyon/pull/2180)

### tachyon-utils

- add `buildCacheHeader` and `getCurrentTwitchDomain` functions
  [PR 2245](https://git.xarth.tv/emerging-platforms/tachyon/pull/22245)
- add ImpressionListener HOC
  [PR 2191](https://git.xarth.tv/emerging-platforms/tachyon/pull/2191)
- exposed MAX_COOKIE_AGE constant for convenience when setting "infinite"
  cookies [PR 2214](https://git.xarth.tv/emerging-platforms/tachyon/pull/2214)

### tachyon-utils-ts

- Enum utilities extracted from tachyon-utils into separate package, though
  still re-exported from tachyon-utils for convenience
  [PR 2241](https://git.xarth.tv/emerging-platforms/tachyon/pull/2241)

### misc

- dependency updates
  [PR 2189](https://git.xarth.tv/emerging-platforms/tachyon/pull/2189)

---

## 14.0.0 (Oct 17, 2019)

### tachyon-polyfill

- add `tachyon-polyfill` package
  [PR 2147](https://git.xarth.tv/emerging-platforms/tachyon/pull/2147)

### tachyon-utils

- convert `useLocalStorage` to `useStorage`
  [PR 2164](https://git.xarth.tv/emerging-platforms/tachyon/pull/2164)
- removed deprecated `Enum.getValueFromString` methods
  [PR 2167](https://git.xarth.tv/emerging-platforms/tachyon/pull/2167)

### misc

- dependency updates
  [PR 2140](https://git.xarth.tv/emerging-platforms/tachyon/pull/2140)
- dependency updates
  [PR 2153](https://git.xarth.tv/emerging-platforms/tachyon/pull/2153)
- remove private packages from distribution
  [PR 2172](https://git.xarth.tv/emerging-platforms/tachyon/pull/2172)

---

## Prior

- sadly lost to history 😢
