# Project Tachyon

[![GitHub](https://img.shields.io/badge/-GitHub-24292e.svg?style=for-the-badge)](https://git.xarth.tv/emerging-platforms/tachyon)
[![Documenation](https://img.shields.io/badge/-Documentation-4b367c.svg?style=for-the-badge)](https://git.xarth.tv/pages/emerging-platforms/tachyon/)
[![Analytics](https://img.shields.io/badge/-Mode%20Analytics-green.svg?style=for-the-badge)](https://modeanalytics.com/twitch/spaces/6405a1094dfe)
[![TeamCity](https://img.shields.io/badge/-TeamCity-yellow.svg?style=for-the-badge)](https://teamcity.xarth.tv/project/EmergingPlatforms_Tachyon)
[![JIRA](https://img.shields.io/badge/-JIRA-orange.svg?style=for-the-badge)](https://jira.twitch.com/projects/EMP/summary)
[![CodeCov](https://codecov.xarth.tv/ghe/emerging-platforms/tachyon/branch/main/graph/badge.svg)](https://codecov.xarth.tv/ghe/emerging-platforms/tachyon)

Project Tachyon is a [Lerna Monorepo](https://github.com/lerna/lerna#about) with
dependency management through
[Yarn Workspaces](https://yarnpkg.com/lang/en/docs/workspaces/).

**Web Apps:**

- [Tomorrow](./apps/tomorrow/README.md): Twitch's
  [mobile web](https://m.twitch.tv) app
- [Starshot](./apps/starshot/README.md): Twitch's universal TV web app
- [Valence](./apps/valence/README.md): A Twitch app (Coming Soon)
- [Sky Map](./apps/sky-map/README.md): A markdown aggregation
  [web app](https://git.xarth.tv/pages/emerging-platforms/tachyon/) for viewing
  docs in Tachyon

**Native Apps:**

- [Laser-Array](./native-apps/laser-array/README.md): Client-side JS loader for
  Starshot
- [WebOS](./native-apps/webos/README.md): WebOS Laser-Array launcher for
  Starshot

**Packages:**

Tachyon contains a number of stand-alone packages that are used in Tachyon and
in a number of external Twitch web projects. To get started read
[Creating And Working With Packages In Tachyon](./packages/README.md).

## Support

Tachyon is managed by the Emerging Platforms team. For general support reach us
at #mobile-web on Slack. For package support reach us at #tachyon-lib-support.
JIRA tickets should be filed against the
[Emerging Platforms (EMP)](https://jira.twitch.com/projects/EMP) project.

## Getting Started

### Setting Up Tachyon

Ensure that you have
[Twinit](https://wiki.twitch.com/display/DTA/Twinit+Services+Proxy+User+Guide)
running if using Amazon VPN or
[Mwinit](https://wiki.twitch.com/display/AD/Using+mwinit+from+Twitch+VPN)
running if using Twitch VPN.

**This only currently works on OS X**

You will need to first [install Docker](https://docs.docker.com/install/) to run
apps locally.

```sh
$ git clone git@git.xarth.tv:emerging-platforms/tachyon.git
$ cd tachyon
$ ./scripts/setup
```

_Note: This script is idempotent. It is useful to occasionally re-run to verify
that no new dependencies are missing._

**Getting Started on Windows**

Tachyon does not officially support Windows, but we do host community maintained
setup instructions for Windows [here](./windows-setup.md).

### Read Up On Tachyon Patterns

Checkout our [patterns](./patterns/README.md) documentation for best practices
and examples.

### Becoming A Contributor

To push branches, follow the instructions to be added as a Tachyon
[contributor](./processes/getting-added-as-a-contributor.md) on Github.

### Exploring GraphQL

To launch a GraphQL playground to help develop against the current schema, run
`yarn gql` from the repo root.

## Rebuilding Tachyon After Origin Updates

From the root of Tachyon:

```sh
$ yarn build
```

_Note: This is required only when one or more packages were introduced or
updated._

## Git Conventions

In order to help keep things organized, we enforce a few conventions for
committing to this repo. See [Working in Git](./policies/git.md) for more
information.

## Troubleshooting Common Issues

### Incorrect Auto-Import Errors

Caused when importing from a package with a non-root (index) path.

For `import { Foo } from 'foo-package';`, example bad paths:

`import { Foo } from 'foo-package/src';`

`import { Foo } from 'foo-package/src/foo';`

`import { Foo } from 'foo-package/esnext/foo';`

**Known TypeScript Error Indicators**

`error TS1205: Cannot re-export a type when the '--isolatedModules' flag is provided.`

`SyntaxError: Unexpected token export`:

```
UnhandledPromiseRejectionWarning: .../tachyon/packages/.../esnext/....js:1
(function (exports, require, module, __filename, __dirname) { export var ...;
                                                              ^^^^^^
SyntaxError: Unexpected token export
```

### Running `yarn` Outside Of Root

- `Cannot find module '@babel/<something>'` during a build:

If you see errors indicating that dependencies are mysteriously missing you may
have accidentally run `yarn` from somewhere other than root. In this case you
need to rebuild `node_modules`. You can do this by running `yarn nuke` from the
root of the repo and then rebuild from there. _NOTE_ This will not work on
Windows.

### NGINX Errors

Occasionally you may still have stale container configs, which would prevent you
from accessing your server even after it has successfully started via
`yarn start` and logs that it is awaiting connections. If you are seeing a 5XX
error with an NGINX splash screen and/or a connection error in the container
logs, you may need to run the setup script again.

Example error log:

```
2020/06/22 16:14:08 [error] 6#6: *2 connect() failed (111: Connection refused) while
connecting to upstream, client: 172.17.0.1, server: localhost.m.twitch.tv, request:
"GET / HTTP/1.1", upstream: "http://192.168.65.2:3003/", host: "localhost.m.twitch.tv"
```

_Note: This message can also occur if the server restarts during hot-reloading
of any base server config code and is not a problem during that process._

From the root of Tachyon:

```sh
$ ./scripts/setup
```
