# Tachyon Moonbase

Moonbase is the frontend app, hosted at
[appeals.twitch.tv](https://appeals.twitch.tv), where users who have received an
enforcement can go find out more information about enforcements or appeal
enforcement decisions.

Moonbase uses it's own separate GraphQL server because edge/GraphQL only serves
1st parties and doesn't have a way of limiting scopes for suspended users. You
can find the code for the appeals edge
[here](https://git.xarth.tv/safety/appealsedge/).

(Note: You can read more about Moonbase in the original
[tech spec](https://docs.google.com/document/d/1gu-XoM2uqJGXGivhi59fEsZS-ZrsxSZpn8yfU3oLUMk/edit))

## Setting Up Moonbase

1. Run through the
   [First Time Setup](https://git.xarth.tv/pages/emerging-platforms/tachyon#getting-started)
   for Tachyon which includes necessary Moonbase setup.
1. Run the following commands:

```bash
$ ./scripts/setup
$ yarn build
$ cd apps/moonbase
$ yarn start
```

1. visit the app in the browser at:
   [https://localhost.appeals.twitch.tv](https://localhost.appeals.twitch.tv).

## App Architecture

### Major Technology choices

- Framework, Build Process, and Server-Side Rendering:
  [Next.js](https://nextjs.org/docs/#setup).
- View Layer: [React](https://reactjs.org/docs/getting-started.html).
- Twitch API Access
  [Relay Modern](https://facebook.github.io/relay/docs/en/introduction-to-relay.html).

## Local Development

If changes have been made to the
[appealsedge](https://git.xarth.tv/safety/appealsedge/) GraphQL schema, you can
update the schema:

```bash
$ cd apps/moonbase
$ yarn schema
```

### Running Locally

```sh
$ yarn start
```

Note for Firefox users: In order to support HTTPS in local development, we use a
self-signed certificate that is added to your system keychain. Because Firefox
maintains its own keychain, when your browser first attempts to load the app it
will attempt to prevent you from visiting the site. You will need to override
its warning by clicking the "Advanced" button on this error page:

![iOS Simulator Manage Devices](../../apps/sky-map/static/tomorrow/processes/local-development/ff-untrusted-https-page.png)

#### Simulating A Production Build Locally

If you need to run Moonbase locally as a fully optimized production build:

```sh
$ yarn prodlike
```

#### Running A Production Environment Locally

If you need to run a full Docker Moonbase environment locally, from the root of
Tachyon:

```sh
$ yarn docker:mnb
```

Then visit `localhost:3003`.

### Running Unit Tests

Tachyon uses [Jest](https://jestjs.io/docs/en/cli) to run unit tests:

```sh
$ yarn test [TestPathPattern]
```

Or for watch mode:

```sh
$ yarn test:watch [TestPathPattern]
```

### Code Formatting

#### Linting via [ESLint](https://eslint.org/)

```sh
$ yarn lint:fix
```

_Note: Integrate ESLint into your IDE for the best experience._
