import type { FC } from 'react';
import { GlowErrorCarSvg } from 'tachyon-more-ui';
import {
  AlignItems,
  CoreText,
  Display,
  FlexDirection,
  Layout,
  TextAlign,
  Title,
} from 'twitch-core-ui';

type ErrorProps = {
  description: string;
  title: string;
};

// istanbul ignore next: trivial
export const Error: FC<ErrorProps> = ({ description, title }) => {
  return (
    <Layout
      alignItems={AlignItems.Center}
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      padding={2}
    >
      <Layout maxWidth="15rem">
        <GlowErrorCarSvg />
      </Layout>
      <Layout margin={{ y: 1 }} textAlign={TextAlign.Center}>
        <Title>{title}</Title>
      </Layout>
      <CoreText>{description}</CoreText>
    </Layout>
  );
};

Error.displayName = 'Error';
