import Faker from 'faker';
import { GlowErrorCarSvg } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText, Title } from 'twitch-core-ui';
import { Error } from '.';

describe(Error, () => {
  const setup = createShallowWrapperFactory(Error, () => ({
    description: Faker.lorem.sentence(),
    title: Faker.lorem.sentence(),
  }));

  it('shows UV Glow', () => {
    const { wrapper } = setup();
    expect(wrapper.find(GlowErrorCarSvg)).toExist();
  });

  it('shows title', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Title)).toExist();
  });

  it('shows description', () => {
    const { wrapper } = setup();
    expect(wrapper.find(CoreText)).toExist();
  });
});
