import type { FC } from 'react';
import {
  AlignItems,
  Display,
  JustifyContent,
  Layout,
  LoadingSpinner,
  Position,
  SpinnerSize,
} from 'twitch-core-ui';

export const LoadingContent: FC = () => (
  <Layout
    alignItems={AlignItems.Center}
    attachBottom
    attachLeft
    attachRight
    attachTop
    display={Display.Flex}
    justifyContent={JustifyContent.Center}
    position={Position.Absolute}
  >
    <LoadingSpinner delay={1000} size={SpinnerSize.Large} />
  </Layout>
);

LoadingContent.displayName = 'LoadingContent';
