import type { FC } from 'react';
import { useCustomTracking } from 'tachyon-event-tracker';
import { useIntl } from 'tachyon-intl';
import { isBrowser } from 'tachyon-utils';
import { Button } from 'twitch-core-ui';
import { CLIENT_ID } from '../../../config';
import { RouteName, renderTachyonLink } from '../../../routing';
import { ClickLoginButtonEvent } from '../../../utils';
import type { SpadeClickLoginButtonEvent } from '../../../utils';

export const LoginButton: FC = () => {
  const { formatMessage } = useIntl();
  const trackLoginEvent = useCustomTracking<SpadeClickLoginButtonEvent>();
  const oAuthURL = () => {
    const redirectUri = `${window.location.protocol}//${window.location.hostname}/oauth`;
    return `https://id.twitch.tv/oauth2/authorize?client_id=${CLIENT_ID}&redirect_uri=${redirectUri}&response_type=token`;
  };

  return isBrowser() ? (
    <Button
      children={formatMessage('Log In', 'Moonbase')}
      linkTo="/deferToRenderLink"
      onClick={() => {
        trackLoginEvent({ event: ClickLoginButtonEvent.Name });
      }}
      renderLink={renderTachyonLink({
        route: RouteName.External,
        routeParams: { href: oAuthURL() },
      })}
    />
  ) : null;
};
LoginButton.displayName = 'LoginButton';
