import type { FC } from 'react';
import { useEffect } from 'react';
import { useCurrentUser } from 'tachyon-auth';
import { RouteName, useTachyonRouter } from '../../../routing';

export const LoginGate: FC = ({ children }) => {
  const { loggedIn } = useCurrentUser();
  const router = useTachyonRouter();

  useEffect(() => {
    if (!loggedIn) {
      router.push({
        route: RouteName.OAuth,
      });
    }
  }, [loggedIn, router]);

  return loggedIn ? <>{children}</> : null;
};

LoginGate.displayName = 'LoginGate';
