import Faker from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { LoginGate } from '.';

let mockUseCurrentUser = { loggedIn: true };
jest.mock('tachyon-auth', () => ({
  ...jest.requireActual('tachyon-auth'),
  useCurrentUser: () => mockUseCurrentUser,
}));

describe(LoginGate, () => {
  const setup = createShallowWrapperFactory(LoginGate, () => ({
    children: <CoreText>{Faker.lorem.sentence()}</CoreText>,
  }));

  it('does not show child components when logged out', () => {
    mockUseCurrentUser = { loggedIn: false };
    const { wrapper } = setup();
    expect(wrapper.find(CoreText)).not.toExist();
  });

  it('shows child components when logged in', () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setup();
    expect(wrapper.find(CoreText)).toExist();
  });
});
