import type { FC } from 'react';
import { useCurrentUser } from 'tachyon-auth';
import { useCustomTracking } from 'tachyon-event-tracker';
import { useIntl } from 'tachyon-intl';
import { Button } from 'twitch-core-ui';
import { ClickLogoutButtonEvent } from '../../../utils';
import type { SpadeClickLogoutButtonEvent } from '../../../utils';

export const LogoutButton: FC = () => {
  const { formatMessage } = useIntl();
  const { logout } = useCurrentUser();
  const trackLogoutEvent = useCustomTracking<SpadeClickLogoutButtonEvent>();

  return (
    <Button
      children={formatMessage('Log Out', 'Moonbase')}
      onClick={() => {
        trackLogoutEvent({ event: ClickLogoutButtonEvent.Name });
        logout();
      }}
    />
  );
};
LogoutButton.displayName = 'LogoutButton';
