import type { FC } from 'react';
import styled from 'styled-components';
import { squareSize } from 'tachyon-more-ui';
import { AnimatedGlitchLogo, CoreLink } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../routing';

const ScGlitch = styled.div`
  & svg {
    ${squareSize({ sizeRem: 5 })}
  }
`;

// istanbul ignore next: trivial
export const Glitch: FC = () => {
  return (
    <CoreLink
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        route: RouteName.Homepage,
      })}
    >
      <ScGlitch>
        <AnimatedGlitchLogo />
      </ScGlitch>
    </CoreLink>
  );
};

Glitch.displayName = 'Glitch';
