import { useFragment } from 'react-relay/hooks';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import {
  Avatar,
  CoreText,
  DropDownMenu,
  DropDownMenuItem,
  DropDownMenuSeparator,
} from 'twitch-core-ui';
import { mockUserInfo, userInfoRefs } from './test-mocks';
import { TopNavDropDownMenu } from '.';

jest.mock('react-relay/hooks', () => ({
  ...jest.requireActual('react-relay/hooks'),
  useFragment: jest.fn(),
}));
const mockUseFragment = useFragment as jest.Mock;

describe(TopNavDropDownMenu, () => {
  const setup = createShallowWrapperFactory(TopNavDropDownMenu, () => ({
    userInfo: userInfoRefs,
  }));

  it('renders TopNavDropDownMenu as expected', () => {
    mockUseFragment.mockImplementationOnce(() => ({
      ...mockUserInfo,
    }));

    const { wrapper } = setup();
    expect(wrapper.find(Avatar)).toHaveLength(2);
    expect(wrapper.find(CoreText)).toHaveLength(2);
    expect(wrapper.find(DropDownMenu)).toHaveLength(1);
    expect(wrapper.find(DropDownMenuItem)).toHaveLength(1);
    expect(wrapper.find(DropDownMenuSeparator)).toHaveLength(1);
  });
});
