import type { FC } from 'react';
import { useCurrentUser } from 'tachyon-auth';
import {
  AlignItems,
  Background,
  CoreText,
  Display,
  FontSize,
  JustifyContent,
  Layout,
  ZIndex,
} from 'twitch-core-ui';
import { LoginButton } from '../LoginButton';
import { LogoutButton } from '../LogoutButton';
import { Glitch } from './Glitch';
import type { TopNavDropDownMenuProps } from './TopNavDropDownMenu';
import { TopNavDropDownMenu } from './TopNavDropDownMenu';

const NavMenuButtonText: FC = ({ children }) => (
  <CoreText bold fontSize={FontSize.Size5}>
    {children}
  </CoreText>
);
NavMenuButtonText.displayName = 'MenuText';

export const NAVBAR_HEIGHT = '6rem';

type TopNavProps = {
  userInfo?: TopNavDropDownMenuProps['userInfo'] | null;
};

export const TopNav: FC<TopNavProps> = ({ userInfo }) => {
  const { loggedIn } = useCurrentUser();

  const loggedInUI = () => {
    if (userInfo) {
      return <TopNavDropDownMenu userInfo={userInfo} />;
    }
    return <LogoutButton />;
  };

  return (
    <Layout
      alignItems={AlignItems.Center}
      background={Background.Alt}
      display={Display.Flex}
      height={NAVBAR_HEIGHT}
      justifyContent={JustifyContent.Between}
      padding={{
        left: 1,
        right: 2,
      }}
      width={'100vw'}
      zIndex={ZIndex.Above}
    >
      <Glitch />
      {loggedIn ? loggedInUI() : <LoginButton />}
    </Layout>
  );
};

TopNav.displayName = 'TopNav';
