import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { LoginButton } from '../LoginButton';
import { LogoutButton } from '../LogoutButton';
import { Glitch } from './Glitch';
import { TopNavDropDownMenu } from './TopNavDropDownMenu';
import { userInfoRefs } from './TopNavDropDownMenu/test-mocks';
import { TopNav } from '.';

let mockUseCurrentUser = { loggedIn: true };
jest.mock('tachyon-auth', () => ({
  ...jest.requireActual('tachyon-auth'),
  useCurrentUser: () => mockUseCurrentUser,
}));

describe(TopNav, () => {
  const setup = createShallowWrapperFactory(TopNav, () => ({
    userInfo: null,
  }));

  it('shows the glitch', () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setup();

    expect(wrapper.find(Glitch)).toExist();
  });

  it("shows the logout button when logged out but userInfo isn't present", () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setup();

    expect(wrapper.find(LogoutButton)).toExist();
  });

  it('shows the dropdown menu with avatar when logged out and userInfo is present', () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setup({ userInfo: userInfoRefs });

    expect(wrapper.find(TopNavDropDownMenu)).toExist();
  });

  it('shows the logout button when logged in', () => {
    mockUseCurrentUser = { loggedIn: false };
    const { wrapper } = setup();

    expect(wrapper.find(LoginButton)).toExist();
  });
});
